"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Validation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _addonActions = require("@storybook/addon-actions");
var _components = require("../../../components");
var _use_form = require("../../hooks/use_form");
var _form = require("../form");
var _use_field = require("../use_field");
var _constants = require("./constants");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/form_validation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const titleConfigWithValidation = {
  ..._constants.titleConfigBase,
  helpText: 'Test validation by leaving field empty.',
  validations: [{
    validator: ({
      value
    }) => {
      (0, _addonActions.action)('Validating title field')(value);
      if (value.trim() === '') {
        return {
          message: `The field can't be empty.`
        };
      }
    }
  }]
};
const Validation = args => {
  const {
    form
  } = (0, _use_form.useForm)();
  return /*#__PURE__*/_react.default.createElement(_form.Form, (0, _extends2.default)({
    form: form
  }, args, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "title",
    component: _components.TextField,
    config: titleConfigWithValidation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => (0, _form_utils.submitForm)(form),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, "Send"));
};
exports.Validation = Validation;
Validation.parameters = {
  docs: {
    source: {
      code: `
const titleConfigWithValidation: FieldConfig<string> = {
  label: 'Title',
  helpText: 'Test validation by leaving field empty.',
  validations: [
    {
      validator: ({ value }) => {
        action('Validating title field')(value);

        if (value.trim() === '') {
          return {
            message: "The field can't be empty.",
          };
        }
      },
    },
  ],
};

const MyFormComponent = () => {
  const { form } = useForm();

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <UseField<string> path="title" component={TextField} config={titleConfigWithValidation} />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};