"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertRangeFilterToTimeRange = convertRangeFilterToTimeRange;
exports.convertRangeFilterToTimeRangeString = convertRangeFilterToTimeRangeString;
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isRelativeTime = value => {
  return typeof value === 'string' && !(0, _moment.default)(value).isValid();
};
function convertRangeFilterToTimeRange(filter) {
  const key = (0, _lodash.keys)(filter.query.range)[0];
  const values = filter.query.range[key];
  const from = values.gt || values.gte;
  const to = values.lt || values.lte;
  return {
    from: from && isRelativeTime(from) ? String(from) : (0, _moment.default)(from),
    to: to && isRelativeTime(to) ? String(to) : (0, _moment.default)(to)
  };
}
function convertRangeFilterToTimeRangeString(filter) {
  const {
    from,
    to
  } = convertRangeFilterToTimeRange(filter);
  return {
    from: _moment.default.isMoment(from) ? from === null || from === void 0 ? void 0 : from.toISOString() : from,
    to: _moment.default.isMoment(to) ? to === null || to === void 0 ? void 0 : to.toISOString() : to
  };
}