"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kqlQuery = kqlQuery;
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function kqlQuery(kql, parseOptions = {}, esQueryOptions = {}) {
  if (!kql) {
    return [];
  }
  const ast = (0, _.fromKueryExpression)(kql, parseOptions);
  return [(0, _.toElasticsearchQuery)(ast, esQueryOptions.indexPattern, esQueryOptions.config, esQueryOptions.context)];
}