"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesJSONConfigurations = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _doc_links = require("../../../../shared/doc_links");
var _http = require("../../../../shared/http");
var _is_managed = require("../../../../shared/pipelines/is_managed");
var _index_view_logic = require("../index_view_logic");
var _pipeline_json_badges = require("./pipeline_json_badges");
var _pipelines_json_configurations_logic = require("./pipelines_json_configurations_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/pipelines_json_configurations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PipelinesJSONConfigurations = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    pipelineNames,
    selectedPipeline,
    selectedPipelineId,
    selectedPipelineJSON
  } = (0, _kea.useValues)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  const {
    selectPipeline
  } = (0, _kea.useActions)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.title', {
      defaultMessage: 'Pipeline configurations'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.subtitle', {
      defaultMessage: 'View the JSON for your pipeline configurations on this index.'
    }),
    footerDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.ingestPipelines,
      target: "_blank",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.ingestionPipelines.docLink', {
      defaultMessage: 'Learn more about how Search uses ingest pipelines'
    })),
    action: pipelineNames.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 13
      }
    }, pipelineNames.length),
    iconType: "visVega",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.selectLabel', {
      defaultMessage: 'Select an ingest pipeline to view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-selectPipeline`,
    fullWidth: true,
    options: pipelineNames.map(name => ({
      text: name,
      value: name
    })),
    value: selectedPipelineId,
    onChange: e => selectPipeline(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), selectedPipeline && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_json_badges.PipelineJSONBadges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }, (0, _is_managed.isManagedPipeline)(selectedPipeline) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-viewInStackManagement`,
    size: "s",
    flush: "both",
    iconType: "eye",
    color: "primary",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/?pipeline=${selectedPipelineId}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.action.view', {
    defaultMessage: 'View in Stack Management'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-editInStackManagement`,
    size: "s",
    flush: "both",
    iconType: "pencil",
    color: "primary",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/edit/${selectedPipelineId}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.action.edit', {
    defaultMessage: 'Edit in Stack Management'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    overflowHeight: 300,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, selectedPipelineJSON))));
};
exports.PipelinesJSONConfigurations = PipelinesJSONConfigurations;