"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextExpansionErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _http = require("../../../../../../shared/http");
var _telemetry = require("../../../../../../shared/telemetry");
var _routes = require("../../../../../routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/text_expansion_callout/text_expansion_errors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TextExpansionErrors = ({
  error
}) => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "error",
    metric: "textExpansionModel-error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: error.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }, error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(_routes.ML_NOTIFICATIONS_PATH),
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCreateError.mlNotificationsLink', {
    defaultMessage: 'Machine Learning notifications'
  }))));
};
exports.TextExpansionErrors = TextExpansionErrors;