"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAnalyticsCollectionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_analytics_collection_form = require("./add_analytics_collection_form");
var _add_analytics_collection_logic = require("./add_analytics_collection_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/add_analytics_collections/add_analytics_collection_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const collectionNameField = 'collection-name';
const minModalWidth = 400;
const AddAnalyticsCollectionModal = ({
  onClose
}) => {
  const {
    isLoading,
    isSuccess,
    isSystemError,
    canSubmit
  } = (0, _kea.useValues)(_add_analytics_collection_logic.AddAnalyticsCollectionLogic);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'createAnalyticsCollection'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'modalTitleId'
  });
  (0, _react.useEffect)(() => {
    if (isSuccess || isSystemError) {
      onClose();
    }
  }, [isSuccess, isSystemError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: minModalWidth,
    "aria-labelledby": modalTitleId,
    initialFocus: `[name=${collectionNameField}]`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.title', {
    defaultMessage: 'Name your Collection'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.subtitle', {
    defaultMessage: "Consider carefully what you want to name your Collection. You can't rename it later."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_add_analytics_collection_form.AddAnalyticsCollectionForm, {
    formId: modalFormId,
    collectionNameField: collectionNameField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchAddAnalyticsCollectionModalCancelButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.cancelButton', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchAddAnalyticsCollectionModalCreateButton",
    fill: true,
    type: "submit",
    form: modalFormId,
    iconType: "plusInCircle",
    isLoading: isLoading,
    isDisabled: !canSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsCreate.form.createButton', {
    defaultMessage: 'Create'
  }))));
};
exports.AddAnalyticsCollectionModal = AddAnalyticsCollectionModal;