"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findPromptsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _schemas = require("@kbn/elastic-assistant-common/impl/schemas");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../../ai_assistant_data_clients/prompts/helpers");
var _helpers2 = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findPromptsRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _common.buildRouteValidationWithZod)(_schemas.FindPromptsRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      const {
        query
      } = request;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers2.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantPromptsDataClient();
      const result = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
        perPage: query.per_page,
        page: query.page,
        sortField: query.sort_field,
        sortOrder: query.sort_order,
        filter: query.filter ? `${decodeURIComponent(query.filter)} and not (is_default: true)` : 'not (is_default: true)',
        fields: query.fields
      }));
      if (result) {
        return response.ok({
          body: {
            perPage: result.perPage,
            page: result.page,
            total: result.total,
            data: (0, _helpers.transformESSearchToPrompts)(result.data)
          }
        });
      }
      return response.ok({
        body: {
          perPage: query.per_page,
          page: query.page,
          data: [],
          total: 0
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.findPromptsRoute = findPromptsRoute;