"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsightsCustomEvaluator = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _errors = require("../../../errors");
var _customIncompatibleAntivirusEvaluator = require("./customIncompatibleAntivirusEvaluator");
var _customPolicyResponseFailureEvaluator = require("./customPolicyResponseFailureEvaluator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefendInsightsCustomEvaluator = ({
  insightType
}) => {
  switch (insightType) {
    case _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus:
      return _customIncompatibleAntivirusEvaluator.customIncompatibleAntivirusEvaluator;
    case _elasticAssistantCommon.DefendInsightType.Enum.policy_response_failure:
      return _customPolicyResponseFailureEvaluator.customPolicyResponseFailureEvaluator;
    default:
      throw new _errors.InvalidDefendInsightTypeError();
  }
};
exports.getDefendInsightsCustomEvaluator = getDefendInsightsCustomEvaluator;