"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantProvider = AssistantProvider;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _assistant_context = require("@kbn/elastic-assistant/impl/assistant_context");
var _get_comments = require("../../components/get_comments");
var _typed_kibana_context = require("../typed_kibana_context/typed_kibana_context");
var _use_inference_enabled = require("../../hooks/inference_enabled/use_inference_enabled");
var _use_app_toasts = require("../../hooks/toasts/use_app_toasts");
var _use_assistant_availability = require("../../hooks/assistant_availability/use_assistant_availability");
var _use_base_path = require("../../hooks/base_path/use_base_path");
var _comment_actions_mounter = require("../../components/comment_actions/comment_actions_mounter");
var _use_assistant_telemetry = require("../../hooks/use_assistant_telemetry");
var _use_is_nav_control_visible = require("../../hooks/is_nav_control_visible/use_is_nav_control_visible");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/context/assistant_context/assistant_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ASSISTANT_TITLE = _i18n.i18n.translate('xpack.elasticAssistantPlugin.assistant.title', {
  defaultMessage: 'Elastic AI Assistant'
});

/**
 * This component configures the Elastic AI Assistant context provider for the Security Solution app.
 */
function AssistantProvider({
  children,
  isServerless,
  openChatTrigger$,
  completeOpenChat
}) {
  const {
    application: {
      navigateToApp,
      currentAppId$,
      getUrlForApp
    },
    http,
    triggersActionsUi: {
      actionTypeRegistry
    },
    docLinks,
    userProfile,
    chrome,
    productDocBase,
    elasticAssistantSharedState,
    settings
  } = (0, _typed_kibana_context.useKibana)().services;
  const inferenceEnabled = (0, _use_inference_enabled.useInferenceEnabled)();
  const basePath = (0, _use_base_path.useBasePath)();
  const {
    isVisible
  } = (0, _use_is_nav_control_visible.useIsNavControlVisible)(isServerless);
  const assistantAvailability = (0, _use_assistant_availability.useAssistantAvailability)();
  const assistantTelemetry = (0, _use_assistant_telemetry.useAssistantTelemetry)();
  const currentAppId = (0, _useObservable.default)(currentAppId$, '');
  const promptContext = (0, _useObservable.default)(elasticAssistantSharedState.promptContexts.getPromptContext$(), {});
  const alertsIndexPattern = (0, _useObservable.default)(elasticAssistantSharedState.signalIndex.getSignalIndex$(), undefined);
  const augmentMessageCodeBlocks = (0, _useObservable.default)(elasticAssistantSharedState.augmentMessageCodeBlocks.getAugmentMessageCodeBlocks$(), {
    mount: () => () => {}
  });
  const toasts = (0, _use_app_toasts.useAppToasts)(); // useAppToasts is the current, non-deprecated method of getting the toasts service in the Security Solution, but it doesn't return the IToasts interface (defined by core)

  const memoizedCommentActionsMounter = (0, _react.useCallback)(args => {
    return /*#__PURE__*/_react.default.createElement(_comment_actions_mounter.CommentActionsMounter, {
      message: args.message,
      getActions$: elasticAssistantSharedState.comments.getActions$(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    });
  }, [elasticAssistantSharedState.comments]);
  const memoizedGetComments = (0, _react.useMemo)(() => {
    return (0, _get_comments.getComments)({
      CommentActions: memoizedCommentActionsMounter
    });
  }, [memoizedCommentActionsMounter]);
  const assistantContextValue = (0, _assistant_context.useAssistantContextValue)({
    actionTypeRegistry,
    alertsIndexPattern,
    augmentMessageCodeBlocks,
    assistantAvailability,
    assistantTelemetry,
    docLinks,
    basePath,
    basePromptContexts: Object.values(promptContext),
    getComments: memoizedGetComments,
    http,
    inferenceEnabled,
    navigateToApp,
    productDocBase,
    title: ASSISTANT_TITLE,
    toasts,
    currentAppId: currentAppId !== null && currentAppId !== void 0 ? currentAppId : 'securitySolutionUI',
    userProfileService: userProfile,
    chrome,
    getUrlForApp,
    openChatTrigger$,
    settings,
    completeOpenChat
  });
  (0, _react.useEffect)(() => {
    elasticAssistantSharedState.assistantContextValue.setAssistantContextValue(assistantContextValue);
  }, [assistantContextValue, elasticAssistantSharedState.assistantContextValue]);
  if (!isVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    value: assistantContextValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, children);
}