"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRawData = void 0;
var _get_anonymized_data = require("../get_anonymized_data");
var _get_anonymized_values = require("../get_anonymized_values");
var _get_csv_from_data = require("../get_csv_from_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRawData = ({
  anonymizationFields,
  currentReplacements,
  getAnonymizedValue,
  onNewReplacements,
  rawData
}) => {
  if (typeof rawData === 'string') {
    return rawData;
  }
  const anonymizedData = (0, _get_anonymized_data.getAnonymizedData)({
    anonymizationFields,
    currentReplacements,
    rawData,
    getAnonymizedValue,
    getAnonymizedValues: _get_anonymized_values.getAnonymizedValues
  });
  if (onNewReplacements != null) {
    onNewReplacements(anonymizedData.replacements);
  }
  return (0, _get_csv_from_data.getCsvFromData)(anonymizedData.anonymizedData);
};
exports.transformRawData = transformRawData;