"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDiscoverEBTManagerAnalytics = exports.TABS_EVENT_TYPE = exports.QUERY_FIELDS_USAGE_FIELD_NAMES = exports.QUERY_FIELDS_USAGE_EVENT_TYPE = exports.FIELD_USAGE_FILTER_OPERATION = exports.FIELD_USAGE_FIELD_NAME = exports.FIELD_USAGE_EVENT_TYPE = exports.FIELD_USAGE_EVENT_NAME = exports.CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE = exports.CONTEXTUAL_PROFILE_LEVEL = exports.CONTEXTUAL_PROFILE_ID = void 0;
var _unifiedTabs = require("@kbn/unified-tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Field usage events i.e. when a field is selected in the data table, removed from the data table, or a filter is added
 */
const FIELD_USAGE_EVENT_TYPE = exports.FIELD_USAGE_EVENT_TYPE = 'discover_field_usage';
const QUERY_FIELDS_USAGE_EVENT_TYPE = exports.QUERY_FIELDS_USAGE_EVENT_TYPE = 'discover_query_fields_usage';
const FIELD_USAGE_EVENT_NAME = exports.FIELD_USAGE_EVENT_NAME = 'eventName';
const FIELD_USAGE_FIELD_NAME = exports.FIELD_USAGE_FIELD_NAME = 'fieldName';
const QUERY_FIELDS_USAGE_FIELD_NAMES = exports.QUERY_FIELDS_USAGE_FIELD_NAMES = 'fieldNames';
const FIELD_USAGE_FILTER_OPERATION = exports.FIELD_USAGE_FILTER_OPERATION = 'filterOperation';

/**
 * Contextual profile resolved event i.e. when a different contextual profile is resolved at root, data source, or document level
 * Duplicated events for the same profile level will not be sent.
 */
const CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE = exports.CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE = 'discover_profile_resolved';
const CONTEXTUAL_PROFILE_LEVEL = exports.CONTEXTUAL_PROFILE_LEVEL = 'contextLevel';
const CONTEXTUAL_PROFILE_ID = exports.CONTEXTUAL_PROFILE_ID = 'profileId';
const TABS_EVENT_TYPE = exports.TABS_EVENT_TYPE = 'discover_tabs';

/**
 * This function is statically imported since analytics registrations must happen at setup,
 * while the EBT manager is loaded dynamically when needed to avoid page load bundle bloat
 */
const registerDiscoverEBTManagerAnalytics = (core, discoverEbtContext$) => {
  // Register Discover specific context to be used in EBT
  core.analytics.registerContextProvider({
    name: 'discover_context',
    context$: discoverEbtContext$,
    schema: {
      discoverProfiles: {
        type: 'array',
        items: {
          type: 'keyword',
          _meta: {
            description: 'List of active Discover context awareness profiles'
          }
        }
      }
      // If we decide to extend EBT context with more properties, we can do it here
    }
  });

  // Register Discover events to be used with EBT
  core.analytics.registerEventType({
    eventType: FIELD_USAGE_EVENT_TYPE,
    schema: {
      [FIELD_USAGE_EVENT_NAME]: {
        type: 'keyword',
        _meta: {
          description: 'The name of the event that is tracked in the metrics i.e. dataTableSelection, dataTableRemoval'
        }
      },
      [FIELD_USAGE_FIELD_NAME]: {
        type: 'keyword',
        _meta: {
          description: "Field name if it is part of ECS schema. For non ECS compliant fields, there's a <non-ecs> placeholder",
          optional: true
        }
      },
      [FIELD_USAGE_FILTER_OPERATION]: {
        type: 'keyword',
        _meta: {
          description: "Operation type when a filter is added i.e. '+', '-', '_exists_'",
          optional: true
        }
      }
    }
  });
  core.analytics.registerEventType({
    eventType: QUERY_FIELDS_USAGE_EVENT_TYPE,
    schema: {
      [FIELD_USAGE_EVENT_NAME]: {
        type: 'keyword',
        _meta: {
          description: 'The name of the event that is tracked in the metrics i.e. kqlQuery, esqlQuery'
        }
      },
      [QUERY_FIELDS_USAGE_FIELD_NAMES]: {
        type: 'array',
        items: {
          type: 'keyword',
          _meta: {
            description: "List of field names if they are part of ECS schema. For non ECS compliant fields, there's a <non-ecs> placeholder"
          }
        }
      }
    }
  });
  core.analytics.registerEventType({
    eventType: CONTEXTUAL_PROFILE_RESOLVED_EVENT_TYPE,
    schema: {
      [CONTEXTUAL_PROFILE_LEVEL]: {
        type: 'keyword',
        _meta: {
          description: 'The context level at which it was resolved i.e. rootLevel, dataSourceLevel, documentLevel'
        }
      },
      [CONTEXTUAL_PROFILE_ID]: {
        type: 'keyword',
        _meta: {
          description: 'The resolved name of the active profile'
        }
      }
    }
  });
  core.analytics.registerEventType({
    eventType: TABS_EVENT_TYPE,
    schema: {
      [_unifiedTabs.TabsEventDataKeys.TABS_EVENT_NAME]: {
        type: 'keyword',
        _meta: {
          description: 'The name of the tab event that is tracked in the metrics i.e. tabCreated, tabClosed'
        }
      },
      [_unifiedTabs.TabsEventDataKeys.TOTAL_TABS_OPEN]: {
        type: 'integer',
        _meta: {
          description: 'The number of total tabs open at the time of an event',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.REMAINING_TABS_COUNT]: {
        type: 'integer',
        _meta: {
          description: 'The number of remaining tabs after an event',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.CLOSED_TABS_COUNT]: {
        type: 'integer',
        _meta: {
          description: 'The number of tabs closed in a single action',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.TAB_ID]: {
        type: 'keyword',
        _meta: {
          description: 'The unique identifier of the tab',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.FROM_INDEX]: {
        type: 'integer',
        _meta: {
          description: 'The original index of the tab being moved',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.TO_INDEX]: {
        type: 'integer',
        _meta: {
          description: 'The new index of the tab being moved',
          optional: true
        }
      },
      [_unifiedTabs.TabsEventDataKeys.SHORTCUT_USED]: {
        type: 'keyword',
        _meta: {
          description: 'The keyboard key used for tab navigation',
          optional: true
        }
      }
    }
  });
};
exports.registerDiscoverEBTManagerAnalytics = registerDiscoverEBTManagerAnalytics;