"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNameCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _cell_actions_popover = require("@kbn/discover-contextual-components/src/data_types/logs/components/cell_actions_popover");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _constants = require("../../../../common/data_types/logs/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/data_types/logs/service_name_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentIcon = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/custom-icons/src/components/agent_icon'))));
const dataTestSubj = 'serviceNameCell';
const agentIconStyle = ({
  euiTheme
}) => (0, _react2.css)`
  margin-right: ${euiTheme.size.xs};
`;
const getServiceNameCell = (serviceNameField, {
  actions
}) => props => {
  const {
    core,
    share
  } = (0, _use_discover_services.useDiscoverServices)();
  const serviceNameValue = (0, _discoverUtils.getFieldValue)(props.row, serviceNameField);
  const field = props.dataView.getFieldByName(serviceNameField);
  const agentName = (0, _discoverUtils.getFieldValue)(props.row, _constants.AGENT_NAME_FIELD);
  const otelSdkLanguage = (0, _discoverUtils.getFieldValue)(props.row, _discoverUtils.OTEL_RESOURCE_ATTRIBUTES_TELEMETRY_SDK_LANGUAGE);
  if (!serviceNameValue) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `${dataTestSubj}-empty`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 14
      }
    }, "-");
  }
  const agentNameIcon = otelSdkLanguage || agentName;
  const getIcon = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: agentNameIcon,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AgentIcon, {
    agentName: agentNameIcon,
    size: "m",
    css: agentIconStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }));
  const value = (0, _discoverUtils.formatFieldValue)(serviceNameValue, props.row.raw, props.fieldFormats, props.dataView, field, 'html');
  return /*#__PURE__*/_react.default.createElement(_cell_actions_popover.FieldBadgeWithActions, {
    onFilter: actions.addFilter,
    icon: getIcon,
    rawValue: serviceNameValue,
    value: value,
    name: serviceNameField,
    property: field,
    core: core,
    share: share,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  });
};
exports.getServiceNameCell = getServiceNameCell;