"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityPercentageIndicator = QualityPercentageIndicator;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/quality_indicator/percentage_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FEW_QUALITY_STATS_DOCS_THRESHOLD = 0.0005;
function QualityPercentageIndicator({
  percentage,
  docsCount = 0,
  fewDocsTooltipContent
}) {
  const isFewDocsAvailable = percentage && percentage < FEW_QUALITY_STATS_DOCS_THRESHOLD;
  return isFewDocsAvailable ? /*#__PURE__*/_react.default.createElement(DatasetWithFewQualityStatsDocs, {
    docsCount: docsCount,
    fewDocsTooltipContent: fewDocsTooltipContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(DatasetWithManyQualityStatsDocs, {
    percentage: percentage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
}
const DatasetWithFewQualityStatsDocs = ({
  docsCount,
  fewDocsTooltipContent
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, "~0%", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: fewDocsTooltipContent(docsCount),
    type: "warning",
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
const DatasetWithManyQualityStatsDocs = ({
  percentage
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: Number(percentage.toFixed(2)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), "%");
};