"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedFieldInfo = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/failed_docs/filed_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const failedDocsErrorsTableNoData = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.noData', {
  defaultMessage: 'No errors found'
});
const FailedFieldInfo = () => {
  const {
    isDegradedFieldsLoading,
    failedDocsErrorsColumns,
    renderedFailedDocsErrorsItems,
    failedDocsErrorsSort,
    isFailedDocsErrorsLoading,
    resultsCount,
    failedDocsErrorsPagination,
    onFailedDocsErrorsTableChange
  } = (0, _hooks.useQualityIssues)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsFailedDocsFlyoutFieldsList-cause`,
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, _translations.failedDocsErrorsColumnName)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.failedDocsErrorsColumnNameTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsFailedDocsFlyoutFieldsList-cause",
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.qualityIssueFlyout.table",
    defaultMessage: "Showing {items}",
    values: {
      items: resultsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "fixed",
    responsiveBreakpoint: true,
    columns: failedDocsErrorsColumns,
    items: renderedFailedDocsErrorsItems !== null && renderedFailedDocsErrorsItems !== void 0 ? renderedFailedDocsErrorsItems : [],
    loading: isFailedDocsErrorsLoading,
    sorting: failedDocsErrorsSort,
    onChange: onFailedDocsErrorsTableChange,
    "data-test-subj": "datasetQualityDetailsFailedDocsTable",
    rowProps: {
      'data-test-subj': 'datasetQualityDetailsFailedDocsTableRow'
    },
    noItemsMessage: isDegradedFieldsLoading ? _translations.overviewDegradedFieldsTableLoadingText : failedDocsErrorsTableNoData,
    pagination: failedDocsErrorsPagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })));
};
exports.FailedFieldInfo = FailedFieldInfo;