"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsActivity = DatasetsActivity;
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
var _data_placeholder = require("./data_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/summary_panel/datasets_activity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DatasetsActivity() {
  const {
    datasetsActivity,
    isDatasetsActivityLoading
  } = (0, _hooks.useSummaryPanelContext)();
  const text = `${datasetsActivity.active} ${_translations.tableSummaryOfText} ${datasetsActivity.total}`;
  return /*#__PURE__*/_react.default.createElement(_data_placeholder.DataPlaceholder, {
    title: _translations.summaryPanelDatasetsActivityText,
    tooltip: _translations.summaryPanelDatasetsActivityTooltipText,
    value: text,
    isLoading: isDatasetsActivityLoading,
    isUserAuthorizedForDataset: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}