"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldNamesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _multi_select_picker = require("../../../common/components/multi_select_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/search_panel/field_name_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataVisualizerFieldNamesFilter = ({
  overallStats,
  setVisibleFieldNames,
  visibleFieldNames,
  showEmptyFields
}) => {
  const items = (0, _react.useMemo)(() => {
    const options = [];
    if (overallStats) {
      Object.keys(overallStats).forEach(key => {
        const fieldsGroup = overallStats[key];
        if (Array.isArray(fieldsGroup) && fieldsGroup.length > 0) {
          fieldsGroup.forEach(field => {
            if ((field.existsInDocs === true || showEmptyFields === true) && field.fieldName !== undefined) {
              options.push({
                value: field.fieldName
              });
            } else {
              options.push({
                value: field.fieldName,
                disabled: true
              });
            }
          });
        }
      });
    }
    return options;
  }, [overallStats, showEmptyFields]);
  const fieldNameTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.index.fieldNameSelect', {
    defaultMessage: 'Field name'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldNameTitle,
    options: items,
    onChange: setVisibleFieldNames,
    checkedOptions: visibleFieldNames,
    dataTestSubj: 'dataVisualizerFieldNameSelect',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
};
exports.DataVisualizerFieldNamesFilter = DataVisualizerFieldNamesFilter;