"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _top_values = require("../../../top_values");
var _utils = require("../../../utils");
var _metric_distribution_chart = require("../metric_distribution_chart");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
var _use_bar_color = require("./use_bar_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/number_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const METRIC_DISTRIBUTION_CHART_WIDTH = 260;
const METRIC_DISTRIBUTION_CHART_HEIGHT = 200;
const NumberContent = ({
  config,
  onAddFilter
}) => {
  var _stats$distribution, _stats$distribution2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const metricDistributionChartContainer = (0, _react2.css)({
    paddingTop: euiTheme.size.xs,
    width: '100%'
  });
  const {
    stats
  } = config;
  const distributionChartData = (0, _react.useMemo)(() => (0, _metric_distribution_chart.buildChartDataFromStats)(stats === null || stats === void 0 ? void 0 : stats.distribution, METRIC_DISTRIBUTION_CHART_WIDTH), [stats === null || stats === void 0 ? void 0 : stats.distribution]);
  const barColor = (0, _use_bar_color.useBarColor)();
  if (stats === undefined) return null;
  const {
    min,
    median,
    max,
    distribution
  } = stats;
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const summaryTableItems = [{
    function: 'min',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.minLabel",
      defaultMessage: "min",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }),
    value: (0, _utils.kibanaFieldFormat)(min, fieldFormat)
  }, ...((0, _mlIsDefined.isDefined)(median) ? [{
    function: 'median',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.medianLabel",
      defaultMessage: "median",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }),
    value: (0, _utils.kibanaFieldFormat)(median, fieldFormat)
  }] : []), {
    function: 'max',
    display: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.maxLabel",
      defaultMessage: "max",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }),
    value: (0, _utils.kibanaFieldFormat)(max, fieldFormat)
  }];
  const summaryTableColumns = [{
    name: '',
    render: summaryItem => summaryItem.display,
    width: '25px',
    align: _eui.LEFT_ALIGNMENT
  }, {
    field: 'value',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 30
      }
    }, v),
    align: _eui.RIGHT_ALIGNMENT
  }];
  const summaryTableTitle = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.summaryTableTitle', {
    defaultMessage: 'Summary'
  });
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerNumberContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvSummaryTable__wrapper dvPanel__wrapper',
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, summaryTableTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: 'dvSummaryTable',
    compressed: true,
    items: summaryTableItems,
    columns: summaryTableColumns,
    tableCaption: summaryTableTitle,
    "data-test-subj": 'dataVisualizerNumberSummaryTable',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  })), stats && /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: stats,
    fieldFormat: fieldFormat,
    barColor: barColor,
    compressed: true,
    onAddFilter: onAddFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), distribution && ((_stats$distribution = stats.distribution) === null || _stats$distribution === void 0 ? void 0 : _stats$distribution.percentiles.length) !== undefined && ((_stats$distribution2 = stats.distribution) === null || _stats$distribution2 === void 0 ? void 0 : _stats$distribution2.percentiles.length) > 2 && /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'dataVisualizerFieldDataMetricDistribution',
    className: "dvPanel__wrapper",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.distributionTitle",
    defaultMessage: "Distribution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: metricDistributionChartContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_distribution_chart.MetricDistributionChart, {
    width: METRIC_DISTRIBUTION_CHART_WIDTH,
    height: METRIC_DISTRIBUTION_CHART_HEIGHT,
    chartData: distributionChartData,
    fieldFormat: fieldFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldExpandedRow.numberContent.displayingPercentilesLabel",
    defaultMessage: "Displaying {minPercent} - {maxPercent} percentiles",
    values: {
      minPercent: (0, _utils.numberAsOrdinal)(distribution.minPercentile),
      maxPercent: (0, _utils.numberAsOrdinal)(distribution.maxPercentile)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 17
    }
  })))));
};
exports.NumberContent = NumberContent;