"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RandomSamplerRangeSlider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _i18nReact = require("@kbn/i18n-react");
var _random_sampler = require("../../../index_data_visualizer/constants/random_sampler");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/random_sampling_menu/random_sampler_range_slider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RandomSamplerRangeSlider = ({
  samplingProbability,
  setSamplingProbability
}) => {
  // Keep track of the input in sampling probability slider when mode is on - manual
  // before 'Apply' is clicked
  const [samplingProbabilityInput, setSamplingProbabilityInput] = (0, _react.useState)(samplingProbability);
  const isInvalidSamplingProbabilityInput = !(0, _mlIsDefined.isDefined)(samplingProbabilityInput) || isNaN(samplingProbabilityInput) || samplingProbabilityInput < _random_sampler.MIN_SAMPLER_PROBABILITY || samplingProbabilityInput > 0.5;
  const inputValue = (samplingProbabilityInput !== null && samplingProbabilityInput !== void 0 ? samplingProbabilityInput : _random_sampler.MIN_SAMPLER_PROBABILITY) * 100;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerPercentageRowLabel', {
      defaultMessage: 'Sampling percentage'
    }),
    helpText: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerPercentageRowHelpText', {
      defaultMessage: 'Choose a value between 0.001% and 50% to randomly sample data.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    fullWidth: true,
    showValue: true,
    showRange: true,
    showLabels: true,
    showInput: "inputWithPopover",
    min: _random_sampler.RANDOM_SAMPLER_STEP,
    max: 50
    // Rounding to 0 decimal place because sometimes js results in weird number when multiplying fractions
    // e.g. 0.07 * 100 yields 7.000000000000001
    ,
    value: inputValue >= 1 ? (0, _mlNumberUtils.roundToDecimalPlace)(inputValue, 0) : (0, _mlNumberUtils.roundToDecimalPlace)(inputValue, 3),
    ticks: _random_sampler.RANDOM_SAMPLER_PROBABILITIES.map(d => ({
      value: d,
      label: d === 0.001 || d >= 5 ? `${d}` : ''
    })),
    isInvalid: isInvalidSamplingProbabilityInput,
    onChange: e => {
      const value = parseFloat(e.target.value);
      const prevValue = samplingProbabilityInput ? samplingProbabilityInput * 100 : value;
      if (value > 0 && value <= 1) {
        setSamplingProbabilityInput(value / 100);
      } else {
        // Because the incremental step is very small (0.0001),
        // everytime user clicks the ^/∨ in the numerical input
        // we need to make sure it rounds up or down to the next whole number
        const nearestInt = value > prevValue ? Math.ceil(value) : Math.floor(value);
        setSamplingProbabilityInput(nearestInt / 100);
      }
    },
    step: _random_sampler.RANDOM_SAMPLER_STEP,
    "data-test-subj": "dvRandomSamplerProbabilityRange",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: isInvalidSamplingProbabilityInput,
      onClick: () => {
        if (setSamplingProbability && (0, _mlIsDefined.isDefined)(samplingProbabilityInput)) {
          setSamplingProbability(samplingProbabilityInput);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerPercentageApply",
      defaultMessage: "Apply",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })));
};
exports.RandomSamplerRangeSlider = RandomSamplerRangeSlider;