"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _default = require("../default/default");
var _samples = require("../../samples");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/number/number.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class NumberFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: [10000, 12.345678, -1, -999, 0.52]
    });
  }
  render() {
    var _this$context$service;
    const {
      format,
      formatParams
    } = this.props;
    const {
      error,
      samples
    } = this.state;
    const defaultPattern = `${format.getParamDefaults().pattern}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.numeralLabel",
        defaultMessage: "Numeral.js format pattern (Default: {defaultPattern})",
        values: {
          defaultPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 47,
              columnNumber: 41
            }
          }, defaultPattern)
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 13
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: (_this$context$service = this.context.services.docLinks) === null || _this$context$service === void 0 ? void 0 : _this$context$service.links.indexPatterns.fieldFormattersNumber,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.number.documentationLabel",
        defaultMessage: "Documentation",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 17
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 17
        }
      }))),
      isInvalid: !!error,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": 'numberEditorFormatPattern',
      value: formatParams.pattern,
      placeholder: defaultPattern,
      onChange: e => {
        this.onChange({
          pattern: e.target.value
        });
      },
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }));
  }
}
exports.NumberFormatEditor = NumberFormatEditor;
(0, _defineProperty2.default)(NumberFormatEditor, "contextType", _public.context);
(0, _defineProperty2.default)(NumberFormatEditor, "formatId", _constants.formatId);