"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requireTimestampOptionValidator = exports.TimestampField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _data_view_editor_service = require("../../data_view_editor_service");
var _shared_imports = require("../../shared_imports");
var _form_schema = require("../form_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/form_fields/timestamp_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const requireTimestampOptionValidator = options => ({
  validator: async ({
    value: selectedOption
  }) => {
    const isValueRequired = !!options.length;
    const valueSelected = options.find(item => item.fieldName === (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.value));
    if (isValueRequired && (!selectedOption || !valueSelected)) {
      return {
        message: _i18n.i18n.translate('indexPatternEditor.requireTimestampOption.ValidationErrorMessage', {
          defaultMessage: 'Select a timestamp field.'
        })
      };
    }
  }
});
exports.requireTimestampOptionValidator = requireTimestampOptionValidator;
const getTimestampConfig = options => {
  const timestampFieldConfig = _form_schema.schema.timestampField;
  const validations = [...timestampFieldConfig.validations,
  // note this is responsible for triggering the state update for the selected source list.
  requireTimestampOptionValidator(options)];
  return {
    ...timestampFieldConfig,
    validations
  };
};
const noTimestampOptionText = _i18n.i18n.translate('indexPatternEditor.editor.form.noTimeFieldsLabel', {
  defaultMessage: 'No matching data stream, index, or index alias has a timestamp field.'
});
const timestampFieldHelp = _i18n.i18n.translate('indexPatternEditor.editor.form.timeFieldHelp', {
  defaultMessage: 'Select a timestamp field for use with the global time filter.'
});
const TimestampField = ({
  options$,
  isLoadingOptions$,
  matchedIndices$,
  disabled
}) => {
  const options = (0, _useObservable.default)(options$, []);
  const isLoadingOptions = (0, _useObservable.default)(isLoadingOptions$, false);
  const hasMatchedIndices = !!(0, _useObservable.default)(matchedIndices$, _data_view_editor_service.matchedIndiciesDefault).exactMatchedIndices.length;
  const optionsAsComboBoxOptions = options.map(({
    display,
    fieldName
  }) => ({
    label: display,
    value: fieldName
  }));
  const timestampConfig = (0, _react.useMemo)(() => getTimestampConfig(options), [options]);
  const selectTimestampHelp = options.length ? timestampFieldHelp : '';
  const timestampNoFieldsHelp = options.length === 0 && !isLoadingOptions && hasMatchedIndices ? noTimestampOptionText : '';
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: timestampConfig,
    path: "timestampField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, field => {
    const {
      label,
      value,
      setValue
    } = field;
    if (value === undefined) {
      return null;
    }
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    const isDisabled = !optionsAsComboBoxOptions.length || isLoadingOptions || disabled;
    // if the value isn't in the list then don't use it.
    const valueInList = !!optionsAsComboBoxOptions.find(option => option.value === value.value);
    if ((!value || !valueInList) && !isDisabled) {
      const val = optionsAsComboBoxOptions.filter(el => el.value === '@timestamp');
      if (val.length) {
        setValue(val[0]);
      }
    }
    const isComboBoxInvalid = !isDisabled && isInvalid;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      error: isDisabled ? null : errorMessage,
      isInvalid: isComboBoxInvalid,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isComboBoxInvalid,
      placeholder: _i18n.i18n.translate('indexPatternEditor.editor.form.runtimeType.placeholderLabel', {
        defaultMessage: 'Select a timestamp field'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: optionsAsComboBoxOptions,
      selectedOptions: value && valueInList ? [value] : undefined,
      onChange: newValue => {
        if (newValue.length === 0) {
          // Don't allow clearing the type. One must always be selected
          return;
        }
        //
        setValue(newValue[0]);
      },
      isClearable: false,
      isDisabled: isDisabled,
      "data-test-subj": "timestampField",
      "aria-label": _i18n.i18n.translate('indexPatternEditor.editor.form.timestampSelectAriaLabel', {
        defaultMessage: 'Timestamp field'
      }),
      isLoading: isLoadingOptions,
      "data-is-loading": isLoadingOptions ? '1' : '0',
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, timestampNoFieldsHelp || selectTimestampHelp || /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0")))));
  });
};
exports.TimestampField = TimestampField;