"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _form_schema = require("../form_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/form_fields/name_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createNameNoDupesValidator = namesNotAllowed => ({
  validator: ({
    value
  }) => {
    if (namesNotAllowed.includes(value)) {
      return {
        message: _i18n.i18n.translate('indexPatternEditor.dataViewExists.ValidationErrorMessage', {
          defaultMessage: 'A data view with this name already exists.'
        })
      };
    }
  }
});
const getNameConfig = ({
  namesNotAllowed
}) => {
  const nameFieldConfig = _form_schema.schema.name;
  const validations = [...nameFieldConfig.validations, createNameNoDupesValidator(namesNotAllowed)];
  return {
    ...nameFieldConfig,
    validations
  };
};
const NameField = ({
  namesNotAllowed,
  disabled
}) => {
  const config = (0, _react.useMemo)(() => getNameConfig({
    namesNotAllowed
  }), [namesNotAllowed]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: config,
    componentProps: {
      euiFieldProps: {
        'aria-label': _i18n.i18n.translate('indexPatternEditor.form.nameAriaLabel', {
          defaultMessage: 'Name field optional'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: field.label,
      fullWidth: true,
      error: errorMessage,
      isInvalid: isInvalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: isInvalid,
      disabled: disabled,
      value: field.value,
      onChange: e => {
        field.setValue(e.target.value);
      },
      fullWidth: true,
      "data-test-subj": "createIndexPatternNameInput",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }));
  });
};
exports.NameField = NameField;