"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardListingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _dashboard_listing = require("../../dashboard_listing/dashboard_listing");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _dashboard_app_no_data = require("../no_data/dashboard_app_no_data");
var _get_dashboard_list_item_link = require("./get_dashboard_list_item_link");
var _dashboard_content_management_service = require("../../services/dashboard_content_management_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/listing_page/dashboard_listing_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardListingPage = ({
  title,
  redirectTo,
  initialFilter,
  kbnUrlStateStorage
}) => {
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let isMounted = true;
    (async () => {
      const isInNoDataState = await (0, _dashboard_app_no_data.isDashboardAppInNoDataState)();
      setShowNoDataPage(isInNoDataState && isMounted);
    })();
    return () => {
      isMounted = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    _kibana_services.coreServices.chrome.setBreadcrumbs([{
      text: (0, _dashboard_app_strings.getDashboardBreadcrumb)()
    }], {
      project: {
        value: []
      }
    });
    if (_kibana_services.serverlessService) {
      // if serverless breadcrumbs available,
      // reset any deeper context breadcrumbs to only keep the main "dashboard" part that comes from the navigation config
      _kibana_services.serverlessService.setBreadcrumbs([]);
    }
  }, []);
  (0, _react.useEffect)(() => {
    // syncs `_g` portion of url with query services
    const {
      stop: stopSyncingQueryServiceStateWithUrl
    } = (0, _public.syncGlobalQueryStateWithUrl)(_kibana_services.dataService.query, kbnUrlStateStorage);
    if (title) {
      (0, _dashboard_content_management_service.getDashboardContentManagementService)().findDashboards.findByTitle(title).then(result => {
        if (!result) return;
        redirectTo({
          destination: 'dashboard',
          id: result.id,
          useReplace: true
        });
      });
    }
    return () => {
      stopSyncingQueryServiceStateWithUrl();
    };
  }, [title, redirectTo, kbnUrlStateStorage]);
  const titleFilter = title ? `${title}` : '';
  if (showNoDataPage === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showNoDataPage && /*#__PURE__*/_react.default.createElement(_dashboard_app_no_data.DashboardAppNoDataPage, {
    onDataViewCreated: () => setShowNoDataPage(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), !showNoDataPage && /*#__PURE__*/_react.default.createElement(_dashboard_listing.DashboardListing, {
    useSessionStorageIntegration: true,
    initialFilter: initialFilter !== null && initialFilter !== void 0 ? initialFilter : titleFilter,
    goToDashboard: (id, viewMode) => {
      redirectTo({
        destination: 'dashboard',
        id,
        editMode: viewMode === 'edit'
      });
    },
    getDashboardUrl: (id, timeRestore) => {
      return (0, _get_dashboard_list_item_link.getDashboardListItemLink)(kbnUrlStateStorage, id, timeRestore);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }));
};
exports.DashboardListingPage = DashboardListingPage;