"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIntegrationsServicesProvider = void 0;
exports.useCustomIntegrationsServices = useCustomIntegrationsServices;
exports.usePlatformService = exports.useFindService = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/custom_integrations/public/services/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Services used by the custom_integrations plugin.
 */

// The React Context used to provide the services to the CustomIntegrations components.
const CustomIntegrationsServicesContext = /*#__PURE__*/(0, _react.createContext)(null);

/**
 * The `React.Context` Provider component for the `CustomIntegrationsServices` context.  Any
 * plugin or environment that consumes CustomIntegrationsServices components needs to wrap their React
 * tree with this provider.
 *
 * Within a plugin, you can  use the CustomIntegrations plugin and retrieve a fully-configured
 * context from the `start` contract.
 */
const CustomIntegrationsServicesProvider = ({
  children,
  ...services
}) => /*#__PURE__*/_react.default.createElement(CustomIntegrationsServicesContext.Provider, {
  value: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 3
  }
}, children);

/**
 * React hook for accessing pre-wired `SharedUxServices`.
 */
exports.CustomIntegrationsServicesProvider = CustomIntegrationsServicesProvider;
function useCustomIntegrationsServices() {
  const context = (0, _react.useContext)(CustomIntegrationsServicesContext);
  if (!context) {
    throw new Error('CustomIntegrationsServicesContext missing.  Ensure your component or React root is wrapped with CustomIntegrationsServicesProvider.');
  }
  return context;
}

/**
 * A React hook that provides connections to the `CustomIntegrationsFindService`.
 */
const useFindService = () => useCustomIntegrationsServices().find;

/**
 * A React hook that provides connections to the `CustomIntegrationsPlatformService`.
 */
exports.useFindService = useFindService;
const usePlatformService = () => useCustomIntegrationsServices().platform;
exports.usePlatformService = usePlatformService;