"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupPublicBaseUrlConfigWarning = exports.MISSING_CONFIG_STORAGE_KEY = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/apps/browser-internal/src/errors/public_base_url.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** Only exported for tests */
const MISSING_CONFIG_STORAGE_KEY = exports.MISSING_CONFIG_STORAGE_KEY = `core.warnings.publicBaseUrlMissingDismissed`;
const setupPublicBaseUrlConfigWarning = ({
  docLinks,
  http,
  notifications,
  storage = window.localStorage,
  location = window.location,
  ...renderContextDeps
}) => {
  if (location.hostname === 'localhost' || location.hostname === '127.0.0.1') {
    return;
  }
  const missingWarningSeen = storage.getItem(MISSING_CONFIG_STORAGE_KEY) === 'true';
  if (missingWarningSeen || http.basePath.publicBaseUrl) {
    return;
  }
  const toast = notifications.toasts.addWarning({
    title: _i18n.i18n.translate('core.ui.publicBaseUrlWarning.configRecommendedTitle', {
      defaultMessage: 'Configuration recommended'
    }),
    text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, renderContextDeps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.publicBaseUrlWarning.configRecommendedDescription",
      defaultMessage: "In a production environment, it is recommended that you configure {configKey}.",
      values: {
        configKey: /*#__PURE__*/_react.default.createElement("code", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 26
          }
        }, "server.publicBaseUrl")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("a", {
      href: `${docLinks.links.server.publicBaseUrl}`,
      target: "_blank",
      rel: "noopener noreferrer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.publicBaseUrlWarning.learnMoreLinkLabel",
      defaultMessage: "Learn more.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: () => {
        notifications.toasts.remove(toast);
        storage.setItem(MISSING_CONFIG_STORAGE_KEY, 'true');
      },
      id: "mute",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.publicBaseUrlWarning.muteWarningButtonLabel",
      defaultMessage: "Mute warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }))))))
  });
};
exports.setupPublicBaseUrlConfigWarning = setupPublicBaseUrlConfigWarning;