"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReorderableTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _body_row = require("./body_row");
var _body_rows = require("./body_rows");
var _draggable_body_row = require("./draggable_body_row");
var _draggable_body_rows = require("./draggable_body_rows");
var _header_row = require("./header_row");
var Styles = _interopRequireWildcard(require("./styles"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/tables/reorderable_table/reorderable_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReorderableTable = ({
  ariaLabel = 'Reorderable table',
  bottomRows = [],
  className = '',
  columns,
  disableDragging = false,
  disableReordering = false,
  items,
  noItemsMessage,
  onReorder = () => undefined,
  rowErrors = () => undefined,
  rowProps = () => ({}),
  showRowIndex = false,
  unreorderableItems = []
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  // Calculate row index offset (header row = 1)
  const rowIndexOffset = 2; // Start body rows at index 2

  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)(className),
    css: Styles.reorderableTableStyles(euiTheme),
    role: "table",
    "aria-label": ariaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_row.HeaderRow, {
    columns: columns,
    leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.reorderableTable.grabHandleScreenReaderOnlyLabel', {
      defaultMessage: 'Grab handle'
    }))),
    spacingForRowIdentifier: showRowIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), items.length === 0 && unreorderableItems.length === 0 && bottomRows.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "NoItems",
    className: "reorderableTableNoItems",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, noItemsMessage)), items.length > 0 && disableReordering && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined,
      ariaRowindex: itemIndex + rowIndexOffset,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), items.length > 0 && !disableReordering && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_draggable_body_rows.DraggableBodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_draggable_body_row.DraggableBodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      disableDragging: disableDragging,
      rowIndex: itemIndex,
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined,
      ariaRowindex: itemIndex + rowIndexOffset,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    }),
    onReorder: onReorder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "unorderableRows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, unreorderableItems.length > 0 && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: unreorderableItems,
    renderItem: (item, itemIndex) => {
      const rowIndex = items.length + itemIndex + rowIndexOffset;
      return /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
        key: `table_draggable_row_${itemIndex}`,
        columns: columns,
        item: item,
        additionalProps: rowProps(item),
        errors: rowErrors(item),
        leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
        rowIdentifier: showRowIndex ? '∞' : undefined,
        ariaRowindex: rowIndex,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 17
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), bottomRows.map((row, rowIndex) => {
    const ariaRowIndex = items.length + unreorderableItems.length + rowIndex + rowIndexOffset;
    return /*#__PURE__*/_react.default.createElement(_body_row.BodyRow // Shoving a generic ReactNode into a BodyRow is kind of a hack
    , {
      key: rowIndex,
      rowIdentifier: showRowIndex ? '∞' : undefined,
      columns: [{
        render: () => row
      }],
      item: {},
      leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
      "data-test-subj": "BottomRow",
      ariaRowindex: ariaRowIndex,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    });
  })));
};
exports.ReorderableTable = ReorderableTable;