"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteColors = PaletteColors;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _color_math = require("../../color/color_math");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/color_picker/palette_colors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function PaletteColors({
  palette,
  palettes,
  color,
  selectColor
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const colors = Array.from({
    length: palette.colorCount
  }, (d, i) => {
    return palette.getColor(i);
  });
  const neutralPalette = palettes.get(_palettes.KbnPalette.Neutral);
  const neutralColors = Array.from({
    length: neutralPalette.colorCount
  }, (d, i) => {
    return neutralPalette.getColor(i);
  });
  const originalColor = color.type === 'categorical' ? color.paletteId === neutralPalette.id ? neutralPalette.getColor(color.colorIndex) : palettes.get(color.paletteId).getColor(color.colorIndex) : color.colorCode;
  const selectedColorSwatchStyle = {
    outline: `currentcolor solid ${euiTheme.border.width.thick}`,
    outlineOffset: `-${euiTheme.border.width.thin}`,
    border: `${euiTheme.border.width.thick} solid ${euiTheme.colors.borderBaseFormsColorSwatch}`
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      padding: 8
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.paletteColorsLabel', {
    defaultMessage: 'Palette colors'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    wrap: true,
    alignItems: "center",
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, colors.map((c, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: c,
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
    "data-test-subj": `lns-colorMapping-colorPicker-staticColor-${index}`,
    css: (0, _color_math.isSameColor)(c, originalColor) ? selectedColorSwatchStyle : undefined,
    color: c,
    onClick: () => selectColor({
      type: 'categorical',
      paletteId: palette.id,
      colorIndex: index
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      padding: 8,
      paddingTop: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.themeAwareColorsLabel', {
    defaultMessage: 'Neutral colors'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "bottom",
    content: _i18n.i18n.translate('coloring.colorMapping.colorPicker.themeAwareColorsTooltip', {
      defaultMessage: 'The provided neutral colors are theme-aware and will change appropriately when switching between light and dark themes.'
    }),
    type: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    wrap: true,
    alignItems: "center",
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, neutralColors.map((c, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: c,
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
    css: (0, _color_math.isSameColor)(c, originalColor) ? selectedColorSwatchStyle : undefined,
    "data-test-subj": `lns-colorMapping-colorPicker-neutralColor-${index}`,
    color: c,
    onClick: () => selectColor({
      type: 'categorical',
      paletteId: neutralPalette.id,
      colorIndex: index
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  })))))));
}