"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorAssignmentMatcher = void 0;
exports.getColorAssignmentMatcher = getColorAssignmentMatcher;
var _common = require("@kbn/data-plugin/common");
var _utils = require("./utils");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var _assignments = /*#__PURE__*/new WeakMap();
var _assignmentMap = /*#__PURE__*/new WeakMap();
var _ColorAssignmentMatcher_brand = /*#__PURE__*/new WeakSet();
/**
 * A class to encapsulate assignment logic
 */
class ColorAssignmentMatcher {
  constructor(assignments) {
    _classPrivateMethodInitSpec(this, _ColorAssignmentMatcher_brand);
    /**
     * Reference to original assignments
     */
    _classPrivateFieldInitSpec(this, _assignments, void 0);
    /**
     * Map values (or keys) to assignment index and match count
     */
    _classPrivateFieldInitSpec(this, _assignmentMap, void 0);
    _classPrivateFieldSet(_assignments, this, assignments);
    _classPrivateFieldSet(_assignmentMap, this, _classPrivateFieldGet(_assignments, this).reduce((acc, assignment, i) => {
      assignment.rules.forEach(rule => {
        const key = getKey(rule);
        if (key !== null) {
          var _acc$get;
          const [index = i, matchCount = 0] = (_acc$get = acc.get(key)) !== null && _acc$get !== void 0 ? _acc$get : [];
          acc.set(key, [index, matchCount + 1]);
        }
      });
      return acc;
    }, new Map()));
  }
  /**
   * Returns count of matching assignments for given value
   */
  getCount(value) {
    const [, count] = _assertClassBrand(_ColorAssignmentMatcher_brand, this, _getMatch).call(this, value);
    return count;
  }

  /**
   * Returns true if given value has multiple matching assignment
   */
  hasDuplicate(value) {
    const [, count] = _assertClassBrand(_ColorAssignmentMatcher_brand, this, _getMatch).call(this, value);
    return count > 1;
  }

  /**
   * Returns true if given value has matching assignment
   */
  hasMatch(value) {
    return this.getCount(value) > 0;
  }

  /**
   * Returns index of first matching assignment for given value
   */
  getIndex(value) {
    const [index] = _assertClassBrand(_ColorAssignmentMatcher_brand, this, _getMatch).call(this, value);
    return index;
  }
}
exports.ColorAssignmentMatcher = ColorAssignmentMatcher;
function _getMatch(value) {
  var _classPrivateFieldGet2;
  const key = (0, _utils.getValueKey)(value);
  return (_classPrivateFieldGet2 = _classPrivateFieldGet(_assignmentMap, this).get(key)) !== null && _classPrivateFieldGet2 !== void 0 ? _classPrivateFieldGet2 : [-1, 0];
}
function getKey(rule) {
  if (rule.type === 'match' && rule.matchEntireWord) {
    return rule.matchCase ? rule.pattern : rule.pattern.toLowerCase();
  }
  if (rule.type === 'raw') {
    return (0, _utils.getValueKey)((0, _common.deserializeField)(rule.value));
  }

  // nondeterministic match, cannot assign ambiguous keys
  // requires pattern matching all previous rules
  return null;
}

/**
 * A simplified map to track assignment match counts
 *
 * key: stringified value or key of instance methods
 * value: count of matching assignments
 */
function getColorAssignmentMatcher(assignments) {
  return new ColorAssignmentMatcher(assignments);
}