"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityTrendGraph = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _use_get_severity_status_color = require("@kbn/cloud-security-posture/src/hooks/use_get_severity_status_color");
var _helpers = require("@kbn/cloud-security-posture/src/utils/helpers");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _chart_panel = require("../../components/chart_panel");
var _use_kibana = require("../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerability_dashboard/vulnerability_trend_graph.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stackAccessors = [_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL, _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH, _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM, _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.LOW];
const DEFAULT_ACCOUNT = 'all';
const chartStyle = {
  width: '100%',
  height: 300
};
const theme = {
  scales: {
    barsPadding: 0.05 // Maintains low margins between bars when chart is full
  },
  legend: {
    spacingBuffer: 45
  }
};
const ViewAllButton = () => {
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateNativeVulnerabilities)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => navToVulnerabilities(),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilityDashboard.viewAllButton.buttonTitle",
    defaultMessage: "View All",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
};
const AccountDropDown = ({
  selectedAccount,
  setSelectedAccount,
  options = []
}) => {
  const accountsLabel = _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.accountsDropDown.prepend.accountsTitle', {
    defaultMessage: 'Accounts'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    css: {
      width: 320
    },
    compressed: true,
    prepend: accountsLabel,
    "aria-label": accountsLabel,
    options: options,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    selectedOptions: options.filter(o => o.value === selectedAccount),
    onChange: selectedOption => {
      setSelectedAccount(selectedOption[0].value || DEFAULT_ACCOUNT);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  });
};
const getUniqueCloudAccountsOptions = vulnTrends => {
  const uniqueCloudAccounts = [];
  vulnTrends.forEach(trendTimepoint => {
    const accountsStats = Object.values(trendTimepoint.vulnerabilities_stats_by_cloud_account || {});
    accountsStats.forEach(accountStats => {
      // Check if the entry already exists based on the cloudAccountId
      const isDuplicate = uniqueCloudAccounts.find(account => account.value === accountStats.cloudAccountId);

      // If no duplicate is found, add the account to the uniqueCloudAccounts array
      if (!isDuplicate) {
        uniqueCloudAccounts.push({
          label: accountStats.cloudAccountName,
          value: accountStats.cloudAccountId
        });
      }
    });
  });
  uniqueCloudAccounts.unshift({
    label: _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.accountsDropDown.option.allTitle', {
      defaultMessage: 'All'
    }),
    value: DEFAULT_ACCOUNT
  });
  return uniqueCloudAccounts;
};
const getTrendData = (vulnTrends, selectedAccount) => {
  if (selectedAccount === DEFAULT_ACCOUNT) {
    const cleanAllTrend = vulnTrends.map(trendTimepoint => {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      const {
        vulnerabilities_stats_by_cloud_account,
        policy_template,
        ...allAccountsTrendData
      } = trendTimepoint;
      return allAccountsTrendData;
    });
    return cleanAllTrend;
  }
  const accountTrend = vulnTrends.map(trendTimepoint => {
    var _trendTimepoint$vulne;
    const selectedAccountStats = (_trendTimepoint$vulne = trendTimepoint.vulnerabilities_stats_by_cloud_account) === null || _trendTimepoint$vulne === void 0 ? void 0 : _trendTimepoint$vulne[selectedAccount];
    if (selectedAccountStats) return {
      '@timestamp': trendTimepoint['@timestamp'],
      ...selectedAccountStats
    };
  }).filter(_helpers.truthy);
  return accountTrend;
};
const VulnerabilityTrendGraph = () => {
  var _getVulnerabilityDash;
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getSeverityStatusColor
  } = (0, _use_get_severity_status_color.useGetSeverityStatusColor)();
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const vulnTrends = ((_getVulnerabilityDash = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash === void 0 ? void 0 : _getVulnerabilityDash.vulnTrends) || [];
  const [selectedAccount, setSelectedAccount] = (0, _react.useState)(DEFAULT_ACCOUNT);
  const trendData = getTrendData(vulnTrends, selectedAccount);
  const bars = (0, _react.useMemo)(() => [{
    id: _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.LOW,
    yAccessors: ['low'],
    color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.LOW)
  }, {
    id: _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM,
    yAccessors: ['medium'],
    color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.MEDIUM)
  }, {
    id: _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH,
    yAccessors: ['high'],
    color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.HIGH)
  }, {
    id: _cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL,
    yAccessors: ['critical'],
    color: getSeverityStatusColor(_cloudSecurityPostureCommon.VULNERABILITIES_SEVERITY.CRITICAL)
  }], [getSeverityStatusColor]);
  return /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilityDashboard.trendGraphChart.trendBySeverityTitle', {
      defaultMessage: 'Trend by severity'
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(AccountDropDown, {
      key: "vulnerability-trend-graph-account-drop-down",
      options: getUniqueCloudAccountsOptions(vulnTrends),
      selectedAccount: selectedAccount,
      setSelectedAccount: setSelectedAccount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(ViewAllButton, {
      key: "vulnerability-trend-graph-view-all-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: chartStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: charts.theme.useChartsBaseTheme(),
    legendPosition: "right",
    showLegend: true,
    theme: theme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: 'bottom',
    tickFormat: (0, _charts.timeFormatter)((0, _charts.niceTimeFormatByDay)(2)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: 'left',
    tickFormat: number => number.toLocaleString(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }), bars.map(bar => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: bar.id,
    id: bar.id,
    xAccessor: '@timestamp',
    yAccessors: bar.yAccessors,
    stackAccessors: stackAccessors,
    data: trendData,
    color: bar.color,
    minBarHeight: 5,
    barSeriesStyle: {
      rect: {
        // Limiting bars max width before 25 days of data
        widthPixel: trendData.length < 25 ? 50 : undefined
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  })))));
};
exports.VulnerabilityTrendGraph = VulnerabilityTrendGraph;