"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.groupPanelRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _helpers = require("../../../common/utils/helpers");
var _test_subjects = require("./test_subjects");
var _translations = require("./translations");
var _cloud_security_grouping = require("../../components/cloud_security_grouping");
var _vulnerability_severity_map = require("../../components/vulnerability_severity_map");
var _cloud_provider_icon = require("../../components/cloud_provider_icon");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/latest_vulnerabilities_group_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$cloudProvider, _bucket$cloudProvider2, _bucket$cloudProvider3, _bucket$description, _bucket$description$b, _bucket$description$b2, _bucket$resourceName, _bucket$resourceName$, _bucket$resourceName$2;
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.LoadingGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }
  const renderNullGroup = title => /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.NullGroup, {
    title: title,
    field: selectedGroup,
    unit: _translations.NULL_GROUPING_UNIT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
  const cloudProvider = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$cloudProvider = bucket.cloudProvider) === null || _bucket$cloudProvider === void 0 ? void 0 : (_bucket$cloudProvider2 = _bucket$cloudProvider.buckets) === null || _bucket$cloudProvider2 === void 0 ? void 0 : (_bucket$cloudProvider3 = _bucket$cloudProvider2[0]) === null || _bucket$cloudProvider3 === void 0 ? void 0 : _bucket$cloudProvider3.key);
  const description = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : (_bucket$description$b = _bucket$description.buckets) === null || _bucket$description$b === void 0 ? void 0 : (_bucket$description$b2 = _bucket$description$b[0]) === null || _bucket$description$b2 === void 0 ? void 0 : _bucket$description$b2.key);
  const cloudProviderName = cloudProvider ? (0, _helpers.getCloudProviderNameFromAbbreviation)(cloudProvider) : '';
  switch (selectedGroup) {
    case _constants.VULNERABILITY_GROUPING_OPTIONS.RESOURCE_ID:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.RESOURCE_ID) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react.css)`
                  display: inline;
                `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$resourceName = bucket.resourceName) === null || _bucket$resourceName === void 0 ? void 0 : (_bucket$resourceName$ = _bucket$resourceName.buckets) === null || _bucket$resourceName$ === void 0 ? void 0 : (_bucket$resourceName$2 = _bucket$resourceName$[0]) === null || _bucket$resourceName$2 === void 0 ? void 0 : _bucket$resourceName$2.key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 19
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket, 'resourceName')))))));
    case _constants.VULNERABILITY_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT_ID) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 9
        }
      }, cloudProvider && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_cloud_provider_icon.CloudProviderIcon, {
        cloudProvider: cloudProvider,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 17
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket, 'accountName'))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 17
        }
      }, cloudProviderName)))));
    default:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.DEFAULT) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket))), description && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 1,
        css: (0, _react.css)`
                        word-break: break-all;
                      `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 21
        }
      }, description))))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const VulnerabilitiesCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s};
        `,
    color: "hollow",
    "data-test-subj": _test_subjects.VULNERABILITIES_GROUPING_COUNTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(bucket.doc_count)));
};
const VulnerabilitiesCount = /*#__PURE__*/_react2.default.memo(VulnerabilitiesCountComponent);
const SeverityStatsComponent = ({
  bucket
}) => {
  var _bucket$critical$doc_, _bucket$critical, _bucket$high$doc_coun, _bucket$high, _bucket$medium$doc_co, _bucket$medium, _bucket$low$doc_count, _bucket$low;
  const severityMap = {
    critical: (_bucket$critical$doc_ = (_bucket$critical = bucket.critical) === null || _bucket$critical === void 0 ? void 0 : _bucket$critical.doc_count) !== null && _bucket$critical$doc_ !== void 0 ? _bucket$critical$doc_ : 0,
    high: (_bucket$high$doc_coun = (_bucket$high = bucket.high) === null || _bucket$high === void 0 ? void 0 : _bucket$high.doc_count) !== null && _bucket$high$doc_coun !== void 0 ? _bucket$high$doc_coun : 0,
    medium: (_bucket$medium$doc_co = (_bucket$medium = bucket.medium) === null || _bucket$medium === void 0 ? void 0 : _bucket$medium.doc_count) !== null && _bucket$medium$doc_co !== void 0 ? _bucket$medium$doc_co : 0,
    low: (_bucket$low$doc_count = (_bucket$low = bucket.low) === null || _bucket$low === void 0 ? void 0 : _bucket$low.doc_count) !== null && _bucket$low$doc_count !== void 0 ? _bucket$low$doc_count : 0
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.grouping.severity",
    defaultMessage: "Severity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_vulnerability_severity_map.VulnerabilitySeverityMap, {
    total: bucket.doc_count,
    severityMap: severityMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })));
};
const SeverityStats = /*#__PURE__*/_react2.default.memo(SeverityStatsComponent);
const groupStatsRenderer = (selectedGroup, bucket) => [{
  title: _translations.VULNERABILITIES,
  component: /*#__PURE__*/_react2.default.createElement(VulnerabilitiesCount, {
    bucket: bucket,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 16
    }
  })
}, {
  title: '',
  component: /*#__PURE__*/_react2.default.createElement(SeverityStats, {
    bucket: bucket,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 16
    }
  })
}];
exports.groupStatsRenderer = groupStatsRenderer;