"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleNameLink = exports.EMPTY_VALUE = exports.CspFlyoutMarkdown = exports.CodeBlock = exports.BenchmarkIcons = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _use_misconfiguration_finding = require("@kbn/cloud-security-posture/src/hooks/use_misconfiguration_finding");
var _create_detection_rule_from_benchmark = require("@kbn/cloud-security-posture/src/utils/create_detection_rule_from_benchmark");
var _cis_logo = _interopRequireDefault(require("../../../assets/icons/cis_logo.svg"));
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/findings_flyout/findings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EMPTY_VALUE = exports.EMPTY_VALUE = '-';
const CodeBlock = props => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
  isCopyable: true,
  paddingSize: "s",
  overflowHeight: 300
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
}));
exports.CodeBlock = CodeBlock;
const CspFlyoutMarkdown = props => /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, (0, _extends2.default)({
  textSize: "s"
}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
}));
exports.CspFlyoutMarkdown = CspFlyoutMarkdown;
const BenchmarkIcons = ({
  benchmarkId,
  benchmarkName,
  size = 'xl'
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 3
  }
}, benchmarkId.startsWith('cis') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: "Center for Internet Security",
  type: _cis_logo.default,
  size: size,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
  type: benchmarkId,
  name: benchmarkName,
  size: size,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 7
  }
})));
exports.BenchmarkIcons = BenchmarkIcons;
const RuleNameLink = ({
  ruleFlyoutLink,
  ruleName
}) => {
  return ruleFlyoutLink && ruleName ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleNameTabField.ruleNameTooltip', {
      defaultMessage: 'Manage Rule'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: ruleFlyoutLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, ruleName)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleName);
};
exports.RuleNameLink = RuleNameLink;
const FindingsRuleFlyout = ({
  ruleId,
  resourceId,
  children
}) => {
  var _data$result$hits$;
  const {
    data
  } = (0, _use_misconfiguration_finding.useMisconfigurationFinding)({
    query: (0, _cloudSecurityPosture.createMisconfigurationFindingsQuery)(resourceId, ruleId),
    enabled: true,
    pageSize: 1
  });
  const finding = data === null || data === void 0 ? void 0 : (_data$result$hits$ = data.result.hits[0]) === null || _data$result$hits$ === void 0 ? void 0 : _data$result$hits$._source;
  if (!finding) return null;
  return children({
    finding,
    createRuleFn: http => (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, finding === null || finding === void 0 ? void 0 : finding.rule)
  });
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = FindingsRuleFlyout;