"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentTime = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _uiTheme = require("@kbn/ui-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/charts/public/static/components/current_time.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Render current time line annotation on @elastic/charts `Chart`
 */
const CurrentTime = ({
  isDarkMode,
  domainEnd
}) => {
  const lineAnnotationStyle = {
    line: {
      strokeWidth: 2,
      stroke: isDarkMode ? _uiTheme.euiDarkVars.euiColorDanger : _uiTheme.euiLightVars.euiColorDanger,
      opacity: 0.7
    }
  };

  // Domain end of 'now' will be milliseconds behind current time, so we extend time by 1 minute and check if
  // the annotation is within this range; if so, the line annotation uses the domainEnd as its value
  const now = (0, _moment.default)();
  const isAnnotationAtEdge = domainEnd ? (0, _moment.default)(domainEnd).add(1, 'm').isAfter(now) && now.isAfter(domainEnd) : false;
  const lineAnnotationData = [{
    dataValue: isAnnotationAtEdge ? domainEnd : now.valueOf()
  }];
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "__current-time__",
    hideTooltips: true,
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: lineAnnotationData,
    style: lineAnnotationStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.CurrentTime = CurrentTime;