"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewEvents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _types = require("../../../../common/types");
var _case_view_tabs = require("../case_view_tabs");
var _domain = require("../../../../common/types/domain");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_events.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseViewEvents = ({
  caseData,
  renderEventsTable: EventsTable
}) => {
  const events = (0, _react.useMemo)(() => caseData.comments.filter(comment => comment.type === _domain.AttachmentType.event).map(attachment => {
    const eventAttachment = attachment;
    return {
      eventId: eventAttachment.eventId,
      index: eventAttachment.index
    };
  }), [caseData.comments]);
  if (!EventsTable) {
    throw new Error('renderEventsTable has not been specified during case plugin init');
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
        width: 100%;
      `,
    "data-test-subj": "case-view-events",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.EVENTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(EventsTable, {
    events: events,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.CaseViewEvents = CaseViewEvents;
CaseViewEvents.displayName = 'CaseViewEvents';