"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllCasesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _types = require("../../../common/ui/types");
var _use_cases_columns = require("./use_cases_columns");
var _table_filters = require("./table_filters");
var _types2 = require("./types");
var _table = require("./table");
var _use_cases_context = require("../cases_context/use_cases_context");
var _cases_metrics = require("./cases_metrics");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_get_cases = require("../../containers/use_get_cases");
var _use_bulk_get_user_profiles = require("../../containers/user_profiles/use_bulk_get_user_profiles");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _permissions = require("../../utils/permissions");
var _use_is_loading_cases = require("./use_is_loading_cases");
var _use_all_cases_state = require("./use_all_cases_state");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_columns_selection = require("./use_cases_columns_selection");
var _constants = require("../../containers/constants");
var _utility_bar = require("./utility_bar");
var _use_check_alert_attachments = require("../../containers/use_check_alert_attachments");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/all_cases_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSortField = field => {
  var _SortFieldCase$field;
  return (// @ts-ignore
    (_SortFieldCase$field = _types.SortFieldCase[field]) !== null && _SortFieldCase$field !== void 0 ? _SortFieldCase$field : _types.SortFieldCase.title
  );
};
const AllCasesList = exports.AllCasesList = /*#__PURE__*/_react.default.memo(({
  hiddenStatuses = [],
  isSelectorView = false,
  onRowClick,
  getAttachments
}) => {
  var _filterOptions$status, _data$total2;
  const {
    owner,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const isLoading = (0, _use_is_loading_cases.useIsLoadingCases)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasOwner = !!owner.length;
  const {
    queryParams,
    setQueryParams,
    filterOptions,
    setFilterOptions
  } = (0, _use_all_cases_state.useAllCasesState)(isSelectorView);
  const [selectedCases, setSelectedCases] = (0, _react.useState)([]);
  const {
    data = _use_get_cases.initialData,
    isFetching: isLoadingCases
  } = (0, _use_get_cases.useGetCases)({
    filterOptions,
    queryParams
  });
  const {
    disabledCases,
    isLoading: isLoadingCaseAttachments
  } = (0, _use_check_alert_attachments.useCheckAlertAttachments)({
    cases: data.cases,
    getAttachments
  });
  const assigneesFromCases = (0, _react.useMemo)(() => {
    return data.cases.reduce((acc, caseInfo) => {
      if (!caseInfo) {
        return acc;
      }
      for (const assignee of caseInfo.assignees) {
        acc.add(assignee.uid);
      }
      return acc;
    }, new Set());
  }, [data.cases]);
  const {
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: Array.from(assigneesFromCases)
  });
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    data: connectors = []
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: queryParams.sortField,
      direction: queryParams.sortOrder
    }
  }), [queryParams.sortField, queryParams.sortOrder]);
  const deselectCases = (0, _react.useCallback)(() => {
    setSelectedCases([]);
  }, [setSelectedCases]);
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    let newQueryParams = queryParams;
    if (sort) {
      newQueryParams = {
        ...newQueryParams,
        sortField: getSortField(sort.field),
        sortOrder: sort.direction
      };
    }
    if (page) {
      newQueryParams = {
        ...newQueryParams,
        page: page.index + 1,
        perPage: page.size
      };
    }
    setQueryParams(newQueryParams);
    deselectCases();
  }, [queryParams, deselectCases, setQueryParams]);
  const onFilterChangedCallback = (0, _react.useCallback)(newFilterOptions => {
    deselectCases();
    setFilterOptions(newFilterOptions);
  }, [deselectCases, setFilterOptions]);
  const {
    selectedColumns,
    setSelectedColumns
  } = (0, _use_cases_columns_selection.useCasesColumnsSelection)();
  const {
    columns,
    isLoadingColumns,
    rowHeader
  } = (0, _use_cases_columns.useCasesColumns)({
    filterStatus: (_filterOptions$status = filterOptions.status) !== null && _filterOptions$status !== void 0 ? _filterOptions$status : [],
    userProfiles: userProfiles !== null && userProfiles !== void 0 ? userProfiles : new Map(),
    isSelectorView,
    connectors,
    onRowClick,
    disableActions: selectedCases.length > 0,
    selectedColumns,
    disabledCases
  });
  const pagination = (0, _react.useMemo)(() => {
    var _data$total;
    return {
      pageIndex: queryParams.page - 1,
      pageSize: queryParams.perPage,
      totalItemCount: (_data$total = data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      pageSizeOptions: _types2.CASES_TABLE_PER_PAGE_VALUES
    };
  }, [data, queryParams]);
  const euiBasicTableSelectionProps = (0, _react.useMemo)(() => ({
    onSelectionChange: setSelectedCases,
    selected: selectedCases,
    selectable: () => !(0, _permissions.isReadOnlyPermissions)(permissions)
  }), [permissions, selectedCases]);
  const isDataEmpty = (0, _react.useMemo)(() => data.total === 0, [data]);
  const tableRowProps = (0, _react.useCallback)(theCase => ({
    'data-test-subj': `cases-table-row-${theCase.id}`
  }), []);
  const onCreateCasePressed = (0, _react.useCallback)(() => {
    onRowClick === null || onRowClick === void 0 ? void 0 : onRowClick(undefined, true);
  }, [onRowClick]);
  const onClearFilters = (0, _react.useCallback)(() => {
    setFilterOptions(_constants.DEFAULT_CASES_TABLE_STATE.filterOptions);
  }, [setFilterOptions]);
  const showClearFiltersButton = !(0, _reactFastCompare.default)(_constants.DEFAULT_CASES_TABLE_STATE.filterOptions, filterOptions);
  const cssStyling = (0, _react.useMemo)(() => isLoading || isLoadingCases || isLoadingColumns ? (0, _react2.css)`
              top: ${euiTheme.size.xxs};
              border-radius: ${euiTheme.border.radius};
              z-index: ${euiTheme.levels.header};
            ` : (0, _react2.css)`
              display: none;
            `, [isLoading, isLoadingCases, isLoadingColumns, euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    className: "essentialAnimation",
    css: cssStyling,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }), !isSelectorView ? /*#__PURE__*/_react.default.createElement(_cases_metrics.CasesMetrics, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 28
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_table_filters.CasesTableFilters, {
    countClosedCases: data.countClosedCases,
    countOpenCases: data.countOpenCases,
    countInProgressCases: data.countInProgressCases,
    onFilterChanged: onFilterChangedCallback,
    availableSolutions: hasOwner ? [] : availableSolutions,
    hiddenStatuses: hiddenStatuses,
    onCreateCasePressed: onCreateCasePressed,
    isSelectorView: isSelectorView,
    isLoading: isLoadingCurrentUserProfile,
    currentUserProfile: currentUserProfile,
    filterOptions: filterOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.CasesTableUtilityBar, {
    pagination: pagination,
    isSelectorView: isSelectorView,
    totalCases: (_data$total2 = data.total) !== null && _data$total2 !== void 0 ? _data$total2 : 0,
    selectedCases: selectedCases,
    deselectCases: deselectCases,
    selectedColumns: selectedColumns,
    onSelectedColumnsChange: setSelectedColumns,
    onClearFilters: onClearFilters,
    showClearFiltersButton: showClearFiltersButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_table.CasesTable, {
    columns: columns,
    rowHeader: rowHeader,
    data: data,
    goToCreateCase: onRowClick ? onCreateCasePressed : undefined,
    isCasesLoading: isLoadingCases,
    isLoadingColumns: isLoadingColumns || isLoadingCaseAttachments,
    isCommentUpdating: isLoadingCases,
    isDataEmpty: isDataEmpty,
    isSelectorView: isSelectorView,
    onChange: tableOnChangeCallback,
    pagination: pagination,
    selection: euiBasicTableSelectionProps,
    sorting: sorting,
    tableRowProps: tableRowProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }));
});
AllCasesList.displayName = 'AllCasesList';