"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssigneesAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_items_action = require("../use_items_action");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/actions/assignees/use_assignees_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useAssigneesAction = ({
  onAction,
  onActionSuccess,
  isDisabled
}) => {
  const {
    isFlyoutOpen,
    onFlyoutClosed,
    onSaveItems,
    openFlyout,
    isActionDisabled
  } = (0, _use_items_action.useItemsAction)({
    fieldKey: 'assignees',
    isDisabled,
    onAction,
    onActionSuccess,
    successToasterTitle: i18n.EDITED_CASES,
    fieldSelector: theCase => theCase.assignees.map(({
      uid
    }) => uid),
    itemsTransformer: items => items.map(item => ({
      uid: item
    }))
  });
  const getAction = selectedCases => {
    return {
      name: i18n.EDIT_ASSIGNEES,
      onClick: () => openFlyout(selectedCases),
      disabled: isActionDisabled,
      'data-test-subj': 'cases-bulk-action-assignees',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "userAvatar",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 13
        }
      }),
      key: 'cases-bulk-action-assignees'
    };
  };
  return {
    getAction,
    isFlyoutOpen,
    onFlyoutClosed,
    onSaveAssignees: onSaveItems
  };
};
exports.useAssigneesAction = useAssigneesAction;