"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadPage = exports.ComposedWorkpadPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _reactRedux = require("react-redux");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRecompose = require("react-recompose");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _functional = require("../../lib/aeroelastic/functional");
var _workpad2 = require("../../routes/workpad");
var _workpad_static_page = require("./workpad_static_page");
var _workpad_interactive_page = require("./workpad_interactive_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_page/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const animationProps = ({
  animation,
  isSelected
}) => animation ? {
  className: animation.name + ' ' + (isSelected ? 'isActive' : 'isInactive'),
  animationStyle: {
    animationDirection: animation.direction,
    animationDuration: '1s' // TODO: Make this configurable
  }
} : {
  className: isSelected ? 'isActive' : 'isInactive',
  animationStyle: {}
};
const mapStateToProps = (state, {
  isSelected,
  pageId,
  isFullscreen
}) => ({
  isInteractive: isSelected && !isFullscreen && (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state),
  elements: (0, _workpad.getNodes)(state, pageId),
  pageStyle: (0, _workpad.getPageById)(state, pageId).style
});
const ComposedWorkpadPage = exports.ComposedWorkpadPage = (0, _reactRecompose.compose)((0, _reactRecompose.shouldUpdate)((0, _functional.not)(_reactFastCompare.default)),
// this is critical, else random unrelated rerenders in the parent cause glitches here
(0, _reactRecompose.withProps)(animationProps), (0, _reactRedux.connect)(mapStateToProps), (0, _reactRecompose.branch)(({
  isInteractive
}) => isInteractive, _workpad_interactive_page.InteractivePage, _workpad_static_page.StaticPage))();
const WorkpadPage = props => {
  const {
    isFullscreen
  } = (0, _react.useContext)(_workpad2.WorkpadRoutingContext);
  return /*#__PURE__*/_react.default.createElement(ComposedWorkpadPage, (0, _extends2.default)({}, props, {
    isFullscreen: isFullscreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 10
    }
  }));
};
exports.WorkpadPage = WorkpadPage;
WorkpadPage.propTypes = {
  pageId: _propTypes.default.string.isRequired
};