"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRecompose = require("react-recompose");
var _app_handler_creators = require("../../../lib/app_handler_creators");
var _elements = require("../../../state/actions/elements");
var _transient = require("../../../state/actions/transient");
var _workpad = require("../../../state/actions/workpad");
var _app = require("../../../state/selectors/app");
var _workpad2 = require("../../../state/selectors/workpad");
var _workpad3 = require("../../../routes/workpad");
var _view_menu = require("./view_menu.component");
var _get_fit_zoom_scale = require("./lib/get_fit_zoom_scale");
var _use_canvas_api = require("../../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/view_menu/view_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapStateToProps = state => {
  return {
    zoomScale: (0, _app.getZoomScale)(state),
    boundingBox: (0, _workpad2.getWorkpadBoundingBox)(state),
    workpadWidth: (0, _workpad2.getWorkpadWidth)(state),
    workpadHeight: (0, _workpad2.getWorkpadHeight)(state),
    isWriteable: (0, _workpad2.isWriteable)(state) && (0, _app.canUserWrite)(state)
  };
};
const mapDispatchToProps = dispatch => ({
  setZoomScale: scale => dispatch((0, _transient.setZoomScale)(scale)),
  setWriteable: isWorkpadWriteable => dispatch((0, _workpad.setWriteable)(isWorkpadWriteable)),
  doRefresh: () => {
    (0, _use_canvas_api.forceReload)();
    dispatch((0, _elements.fetchAllRenderables)());
  }
});
const mergeProps = (stateProps, dispatchProps, ownProps) => {
  const {
    boundingBox,
    workpadWidth,
    workpadHeight,
    ...remainingStateProps
  } = stateProps;
  return {
    ...remainingStateProps,
    ...dispatchProps,
    ...ownProps,
    toggleWriteable: () => dispatchProps.setWriteable(!stateProps.isWriteable),
    fitToWindow: () => dispatchProps.setZoomScale((0, _get_fit_zoom_scale.getFitZoomScale)(boundingBox, workpadWidth, workpadHeight))
  };
};
const ViewMenuWithContext = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    autoplayInterval,
    setAutoplayInterval,
    setFullscreen,
    setRefreshInterval,
    refreshInterval
  } = (0, _react.useContext)(_workpad3.WorkpadRoutingContext);
  const enterFullscreen = (0, _react.useCallback)(() => {
    dispatch((0, _transient.selectToplevelNodes)([]));
    setFullscreen(true);
  }, [dispatch, setFullscreen]);
  return /*#__PURE__*/_react.default.createElement(_view_menu.ViewMenu, (0, _extends2.default)({}, props, {
    enterFullscreen: enterFullscreen,
    setAutoplayInterval: setAutoplayInterval,
    autoplayEnabled: true,
    autoplayInterval: autoplayInterval,
    setRefreshInterval: setRefreshInterval,
    refreshInterval: refreshInterval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }));
};
const ViewMenu = exports.ViewMenu = (0, _reactRecompose.compose)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps), (0, _reactRecompose.withHandlers)(_app_handler_creators.zoomHandlerCreators))(ViewMenuWithContext);