"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _clearable_palette_picker = require("./clearable_palette_picker");
var _palettes = require("../../../../common/lib/palettes");
var _default_palette_picker = require("./default_palette_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/palette_picker/palette_picker/palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PalettePicker = props => {
  const {
    additionalPalettes = []
  } = props;
  const palettes = [..._palettes.palettes, ...additionalPalettes];
  if (props.clearable) {
    return /*#__PURE__*/_react.default.createElement(_clearable_palette_picker.ClearablePalettePicker, {
      palettes: palettes,
      palette: props.palette,
      onChange: props.onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_default_palette_picker.DefaultPalettePicker, {
    palettes: palettes,
    palette: props.palette,
    onChange: props.onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.PalettePicker = PalettePicker;
PalettePicker.propTypes = {
  id: _propTypes.default.string,
  palette: _propTypes.default.object,
  onChange: _propTypes.default.func,
  clearable: _propTypes.default.bool
};