"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementShareContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/element_share_container/element_share_container.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ElementShareContainer extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      renderComplete: false
    });
    (0, _defineProperty2.default)(this, "createDoneChecker", () => {
      const isDevelopment = process.env.NODE_ENV !== 'production';
      if (!isDevelopment) {
        return;
      }
      const {
        functionName
      } = this.props;
      const timeout = 15; // timeout, in seconds
      this.timeout = setTimeout(() => {
        // TODO: show this message in a proper notification
        console.warn(`done handler not called in render function after ${timeout} seconds: ${functionName}`);
      }, timeout * 1000);
    });
    (0, _defineProperty2.default)(this, "clearDoneChecker", () => {
      clearTimeout(this.timeout);
    });
  }
  componentDidMount() {
    const {
      onComplete
    } = this.props;

    // check that the done event is called within a certain time
    this.createDoneChecker();

    // dispatches a custom DOM event on the container when the element is complete
    onComplete(() => {
      this.clearDoneChecker();
      if (!this.sharedItemRef) {
        return;
      } // without this, crazy fast forward/backward paging leads to an error
      const ev = new CustomEvent('renderComplete');
      this.sharedItemRef.dispatchEvent(ev);

      // if the element is finished before reporting is listening for the
      // renderComplete event, the report never completes. to get around that
      // issue, track the completed state locally and set the
      // [data-render-complete] value accordingly.
      // this is similar to renderComplete directive in Kibana,
      // see: src/legacy/ui/public/render_complete/directive.js
      this.setState({
        renderComplete: true
      });
    });
  }
  getSnapshotBeforeUpdate(prevProps) {
    return {
      functionName: prevProps.functionName
    };
  }
  componentDidUpdate(prevProps, prevState, snapshot) {
    // if function name changed, clear and recreate done checker
    if (snapshot.functionName !== this.props.functionName) {
      this.clearDoneChecker();
      this.createDoneChecker();
    }
  }
  componentWillUnmount() {
    this.clearDoneChecker();
  }
  render() {
    const shouldTrackComplete = this.props.functionName !== 'embeddable';

    // NOTE: the data-shared-item and data-render-complete attributes are used for reporting
    // Embeddables should be setting data-shared-item and data-render-complete on themselves
    // so we should not be tracking them here.
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-shared-item": shouldTrackComplete ? this.state.renderComplete : undefined,
      "data-render-complete": shouldTrackComplete ? this.state.renderComplete : undefined,
      className: this.props.className,
      ref: ref => this.sharedItemRef = ref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, this.props.children);
  }
}
exports.ElementShareContainer = ElementShareContainer;
(0, _defineProperty2.default)(ElementShareContainer, "propTypes", {
  functionName: _propTypes.default.string.isRequired,
  onComplete: _propTypes.default.func.isRequired,
  className: _propTypes.default.string,
  children: _propTypes.default.node.isRequired
});