"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelion = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _arg_helpers = require("../../../public/lib/arg_helpers");
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _i18n = require("../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/datasources/timelion.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  Timelion: strings
} = _i18n.DataSourceStrings;
const TimelionDatasource = ({
  args,
  updateArgs,
  defaultIndex
}) => {
  const DEFAULT_QUERY = `.es(index=${defaultIndex})`;
  const setArg = (name, value) => {
    updateArgs && updateArgs({
      ...args,
      ...(0, _arg_helpers.setSimpleArg)(name, value)
    });
  };
  const getArgName = () => {
    if ((0, _arg_helpers.getSimpleArg)('_', args)[0]) {
      return '_';
    }
    if ((0, _arg_helpers.getSimpleArg)('q', args)[0]) {
      return 'q';
    }
    return 'query';
  };
  const argName = getArgName();

  // TODO: This is a terrible way of doing defaults. We need to find a way to read the defaults for the function
  // and set them for the data source UI.
  const getQuery = () => {
    return (0, _arg_helpers.getSimpleArg)(argName, args)[0] || DEFAULT_QUERY;
  };
  const getInterval = () => {
    return (0, _arg_helpers.getSimpleArg)('interval', args)[0] || 'auto';
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: strings.getTipsHeading(),
    size: "s",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.uis.dataSources.timelion.tips.time",
    defaultMessage: "{timelion} requires a time range. Add a time filter element to your page or use the expression editor to pass one in.",
    values: {
      timelion: _i18n.TIMELION
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.uis.dataSources.timelion.tips.functions",
    defaultMessage: "Some {timelion} functions, such as {functionExample}, do not translate to a {canvas} data table. However, anything todo with data manipulation should work as expected.",
    values: {
      timelion: _i18n.TIMELION,
      canvas: _i18n.CANVAS,
      functionExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 34
        }
      }, ".color()")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getQueryLabel(),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _i18n.TIMELION_QUERY_URL,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, strings.queryLabel())),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    className: "canvasTextArea__code",
    value: getQuery(),
    onChange: e => setArg(argName, e.target.value),
    rows: 15,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getIntervalLabel(),
    helpText: strings.getIntervalHelp(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    value: getInterval(),
    onChange: e => setArg('interval', e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  })));
};
TimelionDatasource.propTypes = {
  args: _propTypes.default.object.isRequired,
  updateArgs: _propTypes.default.func,
  defaultIndex: _propTypes.default.string
};
const timelion = () => ({
  name: 'timelion',
  displayName: _i18n.TIMELION,
  help: strings.getHelp(),
  image: 'visTimelion',
  template: (0, _template_from_react_component.templateFromReactComponent)(TimelionDatasource)
});
exports.timelion = timelion;