"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageCardPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/integration_step/package_card_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useCardCss = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react2.css)`
    margin-top: calc(
      ${euiTheme.size.m} + 7px
    ); // To align with title input that has a margin-top of 4px to the label

    min-height: 127px;

    [class*='euiCard__content'] {
      display: flex;
      flex-direction: column;
      block-size: 100%;
    }

    [class*='euiCard__description'] {
      flex-grow: 1;
    }
  `;
};
const PackageCardPreview = exports.PackageCardPreview = /*#__PURE__*/_react.default.memo(({
  integrationSettings
}) => {
  var _integrationSettings$, _integrationSettings$2;
  const cardCss = useCardCss();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: cardCss,
    "data-test-subj": "packageCardPreview",
    layout: "horizontal",
    title: (_integrationSettings$ = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.title) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : '',
    description: (_integrationSettings$2 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.description) !== null && _integrationSettings$2 !== void 0 ? _integrationSettings$2 : '',
    titleSize: "xs",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: 'xl',
      "data-test-subj": "packageCardPreviewIcon",
      type: integrationSettings !== null && integrationSettings !== void 0 && integrationSettings.logo ? `data:image/svg+xml;base64,${integrationSettings.logo}` : 'package',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    betaBadgeProps: {
      label: i18n.PREVIEW,
      tooltipContent: i18n.PREVIEW_TOOLTIP
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
});
PackageCardPreview.displayName = 'PackageCardPreview';