"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncateWithTooltip = TruncateWithTooltip;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _style = require("../../../utils/style");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/truncate_with_tooltip/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tooltipAnchorClassname = '_apm_truncate_tooltip_anchor_';
const TooltipWrapper = _styled.default.div`
  width: 100%;
  .${tooltipAnchorClassname} {
    width: 100% !important;
    display: block !important;
  }
`;
const ContentWrapper = _styled.default.div`
  ${(0, _style.truncate)('100%')}
`;
function TruncateWithTooltip(props) {
  const {
    text,
    content,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(TooltipWrapper, (0, _extends2.default)({}, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: text,
    anchorClassName: tooltipAnchorClassname,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ContentWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, content || text)));
}