"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _formatters = require("../../../../common/utils/formatters");
var _get_timeseries_color = require("../charts/helper/get_timeseries_color");
var _impact_bar = require("../impact_bar");
var _transaction_detail_link = require("../links/apm/transaction_detail_link");
var _list_metric = require("../list_metric");
var _get_comparison_options = require("../time_comparison/get_comparison_options");
var _get_latency_column_label = require("./get_latency_column_label");
var _style = require("../../../utils/style");
var _apm = require("../../../../common/es_fields/apm");
var _field_value_pair_to_kql = require("../../../../common/utils/field_value_pair_to_kql");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/transactions_table/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getColumns({
  serviceName,
  latencyAggregationType,
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  shouldShowSparkPlots = true,
  showAlertsColumn,
  offset,
  transactionOverflowCount,
  link,
  query
}) {
  return [...(showAlertsColumn ? [{
    field: 'alertsCount',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.transactionsTableColumnName.alertsColumnLabel', {
      defaultMessage: 'Active alerts'
    }),
    width: `${_style.unit * 6}px`,
    render: (_, {
      alertsCount,
      name,
      transactionType
    }) => {
      if (!alertsCount) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: _i18n.i18n.translate('xpack.apm.home.transactionsTableColumnName.tooltip.activeAlertsExplanation', {
          defaultMessage: 'Active alerts'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        color: "danger",
        href: link('/services/{serviceName}/alerts', {
          path: {
            serviceName
          },
          query: {
            ...query,
            kuery: [query.kuery, ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.TRANSACTION_NAME, name), ...(0, _field_value_pair_to_kql.fieldValuePairToKql)(_apm.TRANSACTION_TYPE, transactionType)].filter(Boolean).join(' and '),
            alertStatus: _technical_rule_data_field_names.ALERT_STATUS_ACTIVE
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 19
        }
      }, alertsCount));
    }
  }] : []), {
    field: 'name',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnName', {
      defaultMessage: 'Name'
    }),
    width: '30%',
    render: (_, {
      name,
      transactionType: type
    }) => {
      return /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
        transactionName: name,
        href: link('/services/{serviceName}/transactions/view', {
          path: {
            serviceName
          },
          query: {
            ...query,
            transactionName: name,
            transactionType: type,
            comparisonEnabled,
            offset
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 11
        }
      }, name);
    }
  }, {
    field: 'latency',
    sortable: true,
    name: (0, _get_latency_column_label.getLatencyColumnLabel)(latencyAggregationType),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      latency,
      name
    }) => {
      var _detailedStatistics$c, _detailedStatistics$c2, _detailedStatistics$p, _detailedStatistics$p2;
      const currentTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c = detailedStatistics.currentPeriod) === null || _detailedStatistics$c === void 0 ? void 0 : (_detailedStatistics$c2 = _detailedStatistics$c[name]) === null || _detailedStatistics$c2 === void 0 ? void 0 : _detailedStatistics$c2.latency;
      const previousTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p = detailedStatistics.previousPeriod) === null || _detailedStatistics$p === void 0 ? void 0 : (_detailedStatistics$p2 = _detailedStatistics$p[name]) === null || _detailedStatistics$p2 === void 0 ? void 0 : _detailedStatistics$p2.latency;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: detailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'throughput',
    sortable: true,
    name: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnThroughput', {
      defaultMessage: 'Throughput'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      throughput,
      name
    }) => {
      var _detailedStatistics$c3, _detailedStatistics$c4, _detailedStatistics$p3, _detailedStatistics$p4;
      const currentTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c3 = detailedStatistics.currentPeriod) === null || _detailedStatistics$c3 === void 0 ? void 0 : (_detailedStatistics$c4 = _detailedStatistics$c3[name]) === null || _detailedStatistics$c4 === void 0 ? void 0 : _detailedStatistics$c4.throughput;
      const previousTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p3 = detailedStatistics.previousPeriod) === null || _detailedStatistics$p3 === void 0 ? void 0 : (_detailedStatistics$p4 = _detailedStatistics$p3[name]) === null || _detailedStatistics$p4 === void 0 ? void 0 : _detailedStatistics$p4.throughput;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: detailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'errorRate',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignCenter",
      content: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnErrorRateTip', {
        defaultMessage: "The percentage of failed transactions for the selected service. HTTP server transactions with a 4xx status code (client error) aren't considered failures because the caller, not the server, caused the failure."
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 11
      }
    })),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      errorRate,
      name
    }) => {
      var _detailedStatistics$c5, _detailedStatistics$c6, _detailedStatistics$p5, _detailedStatistics$p6;
      const currentTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c5 = detailedStatistics.currentPeriod) === null || _detailedStatistics$c5 === void 0 ? void 0 : (_detailedStatistics$c6 = _detailedStatistics$c5[name]) === null || _detailedStatistics$c6 === void 0 ? void 0 : _detailedStatistics$c6.errorRate;
      const previousTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p5 = detailedStatistics.previousPeriod) === null || _detailedStatistics$p5 === void 0 ? void 0 : (_detailedStatistics$p6 = _detailedStatistics$p5[name]) === null || _detailedStatistics$p6 === void 0 ? void 0 : _detailedStatistics$p6.errorRate;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        color: currentPeriodColor,
        compact: true,
        hideSeries: !shouldShowSparkPlots,
        isLoading: detailedStatisticsLoading,
        series: currentTimeseries,
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousTimeseries : undefined,
        valueLabel: (0, _formatters.asPercent)(errorRate, 1),
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'impact',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnImpact', {
      defaultMessage: 'Impact'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignCenter",
      content: _i18n.i18n.translate('xpack.apm.serviceOverview.transactionsTableColumnImpactTip', {
        defaultMessage: 'The most used and slowest endpoints in your service. Calculated by multiplying latency by throughput.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 11
      }
    })),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      name
    }) => {
      var _detailedStatistics$c7, _detailedStatistics$c8, _detailedStatistics$c9, _detailedStatistics$p7, _detailedStatistics$p8;
      const currentImpact = (_detailedStatistics$c7 = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c8 = detailedStatistics.currentPeriod) === null || _detailedStatistics$c8 === void 0 ? void 0 : (_detailedStatistics$c9 = _detailedStatistics$c8[name]) === null || _detailedStatistics$c9 === void 0 ? void 0 : _detailedStatistics$c9.impact) !== null && _detailedStatistics$c7 !== void 0 ? _detailedStatistics$c7 : 0;
      const previousImpact = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p7 = detailedStatistics.previousPeriod) === null || _detailedStatistics$p7 === void 0 ? void 0 : (_detailedStatistics$p8 = _detailedStatistics$p7[name]) === null || _detailedStatistics$p8 === void 0 ? void 0 : _detailedStatistics$p8.impact;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "xs",
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: currentImpact,
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 282,
          columnNumber: 15
        }
      })), comparisonEnabled && previousImpact !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
        value: previousImpact,
        size: "s",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 17
        }
      })));
    }
  }];
}