"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionActionMenu = TransactionActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _common2 = require("@kbn/logs-shared-plugin/common");
var _common3 = require("@kbn/observability-plugin/common");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _apm_feature_flags = require("../../../../common/apm_feature_flags");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_license_context = require("../../../context/license/use_license_context");
var _use_apm_feature_flag = require("../../../hooks/use_apm_feature_flag");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_profiling_plugin = require("../../../hooks/use_profiling_plugin");
var _custom_link_menu_section = require("./custom_link_menu_section");
var _sections = require("./sections");
var _custom_link_flyout = require("./custom_link_flyout");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/transaction_action_menu/transaction_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ActionMenuButton({
  onClick,
  isLoading
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmActionMenuButtonInvestigateButton",
    isLoading: isLoading,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.transactionActionMenu.actionsButtonLabel', {
    defaultMessage: 'Investigate'
  }));
}
function TransactionActionMenu({
  transaction,
  isLoading
}) {
  const license = (0, _use_license_context.useLicenseContext)();
  const hasGoldLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('gold'));
  const [isActionPopoverOpen, setIsActionPopoverOpen] = (0, _react.useState)(false);
  const {
    isProfilingPluginInitialized,
    profilingLocators
  } = (0, _use_profiling_plugin.useProfilingPlugin)();
  const [isCreateEditFlyoutOpen, setIsCreateEditFlyoutOpen] = (0, _react.useState)(false);
  function openCustomLinkFlyout() {
    setIsCreateEditFlyoutOpen(true);
    setIsActionPopoverOpen(false);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasGoldLicense && /*#__PURE__*/_react.default.createElement(_custom_link_flyout.CustomLinkFlyout, {
    transaction: transaction,
    isOpen: isCreateEditFlyoutOpen,
    onClose: () => setIsCreateEditFlyoutOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ActionMenu, {
    id: "transactionActionMenu",
    closePopover: () => setIsActionPopoverOpen(false),
    isOpen: isActionPopoverOpen,
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(ActionMenuButton, {
      isLoading: isLoading || isProfilingPluginInitialized === undefined,
      onClick: () => setIsActionPopoverOpen(prevIsActionPopoverOpen => !prevIsActionPopoverOpen),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ActionMenuSections, {
    transaction: transaction,
    profilingLocators: profilingLocators,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), hasGoldLicense && /*#__PURE__*/_react.default.createElement(_custom_link_menu_section.CustomLinkMenuSection, {
    transaction: transaction,
    openCreateCustomLinkFlyout: openCustomLinkFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })));
}
function ActionMenuSections({
  transaction,
  profilingLocators
}) {
  var _externalMenuItems$va;
  const {
    core,
    uiActions,
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const logsLocator = (0, _common2.getLogsLocatorFromUrlService)(share.url);
  const uptimeLocator = share.url.locators.get(_common3.uptimeOverviewLocatorID);
  const infraLinksAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.InfraUiAvailable);
  const assetDetailsLocator = share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer/waterfall', '/dependencies/operation');
  const sections = (0, _sections.getSections)({
    transaction,
    basePath: core.http.basePath,
    location,
    apmRouter,
    infraLinksAvailable,
    uptimeLocator,
    profilingLocators,
    rangeFrom,
    rangeTo,
    environment,
    logsLocator,
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    assetDetailsLocator
  });
  const externalMenuItems = (0, _useAsync.default)(() => {
    return transaction ? (0, _public.getContextMenuItemsFromActions)({
      uiActions,
      triggerId: _common.ObservabilityTriggerId.ApmTransactionContextMenu,
      context: transaction
    }) : Promise.resolve([]);
  }, [transaction, uiActions]);
  if ((_externalMenuItems$va = externalMenuItems.value) !== null && _externalMenuItems$va !== void 0 && _externalMenuItems$va.length) {
    sections.push([{
      key: 'external',
      actions: externalMenuItems.value.map((item, i) => {
        return {
          condition: true,
          key: `external-${i}`,
          label: item.children,
          onClick: item.onClick,
          href: item.href
        };
      })
    }]);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmActionMenuInvestigateButtonPopup",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }, sections.map((section, idx) => {
    const isLastSection = idx !== sections.length - 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 11
      }
    }, section.map(item => /*#__PURE__*/_react.default.createElement(_public.Section, {
      key: item.key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 15
      }
    }, item.title && /*#__PURE__*/_react.default.createElement(_public.SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 32
      }
    }, item.title), item.subtitle && /*#__PURE__*/_react.default.createElement(_public.SectionSubtitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 35
      }
    }, item.subtitle), /*#__PURE__*/_react.default.createElement(_public.SectionLinks, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 17
      }
    }, item.actions.map(action => /*#__PURE__*/_react.default.createElement(_public.SectionLink, {
      key: action.key,
      label: action.label,
      href: action.href,
      onClick: action.onClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 21
      }
    }))))), isLastSection && /*#__PURE__*/_react.default.createElement(_public.ActionMenuDivider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 31
      }
    }));
  }));
}