"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _polished = require("polished");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _style = require("../../../../utils/style");
var _suggestion = _interopRequireDefault(require("./suggestion"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/kuery_bar/typeahead/suggestions.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const List = _styled.default.ul`
  width: 100%;
  border: 1px solid ${({
  theme
}) => theme.euiTheme.colors.lightShade};
  border-radius: ${({
  theme
}) => theme.euiTheme.border.radius.small};
  box-shadow: 0
    ${({
  theme
}) => `${theme.euiTheme.size.xs} ${theme.euiTheme.size.xl} ${(0, _polished.tint)(0.9, theme.euiTheme.colors.fullShade)}`};
  position: absolute;
  background: ${({
  theme
}) => theme.euiTheme.colors.emptyShade};
  z-index: 10;
  left: 0;
  max-height: ${_style.unit * 20}px;
  overflow: scroll;
`;
class Suggestions extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "childNodes", []);
    (0, _defineProperty2.default)(this, "scrollIntoView", () => {
      const parent = this.parentNode;
      const child = this.childNodes[this.props.index];
      if (this.props.index == null || !parent || !child) {
        return;
      }
      const scrollTop = Math.max(Math.min(parent.scrollTop, child.offsetTop), child.offsetTop + child.offsetHeight - parent.offsetHeight);
      parent.scrollTop = scrollTop;
    });
  }
  componentDidUpdate(prevProps) {
    if (prevProps.index !== this.props.index) {
      this.scrollIntoView();
    }
  }
  render() {
    if (!this.props.show || (0, _lodash.isEmpty)(this.props.suggestions)) {
      return null;
    }
    const suggestions = this.props.suggestions.map((suggestion, index) => {
      const key = suggestion + '_' + index;
      return /*#__PURE__*/_react.default.createElement(_suggestion.default, {
        innerRef: node => this.childNodes[index] = node,
        selected: index === this.props.index,
        suggestion: suggestion,
        onClick: this.props.onClick,
        onMouseEnter: () => this.props.onMouseEnter(index),
        key: key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 9
        }
      });
    });
    return /*#__PURE__*/_react.default.createElement(List, {
      "data-test-subj": "suggestionContainer",
      innerRef: node => this.parentNode = node,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }, suggestions);
  }
}
Suggestions.propTypes = {
  index: _propTypes.default.number,
  onClick: _propTypes.default.func.isRequired,
  onMouseEnter: _propTypes.default.func.isRequired,
  show: _propTypes.default.bool,
  suggestions: _propTypes.default.array.isRequired
};
var _default = exports.default = Suggestions;
module.exports = exports.default;