"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DISCOVERY_RULE_TYPE_ALL = void 0;
exports.RuntimeAttachment = RuntimeAttachment;
exports.STAGED_DISCOVERY_RULE_ID = void 0;
exports.validateVersion = validateVersion;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _runtime_attachment = require("./runtime_attachment");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_agents/runtime_attachment/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STAGED_DISCOVERY_RULE_ID = exports.STAGED_DISCOVERY_RULE_ID = 'STAGED_DISCOVERY_RULE_ID';
const DISCOVERY_RULE_TYPE_ALL = exports.DISCOVERY_RULE_TYPE_ALL = 'all';
const versionRegex = new RegExp(/latest|^\d+\.\d+\.\d+(\.\w+)?$/);
function validateVersion(version) {
  if (version) {
    return versionRegex.test(version);
  }
  return false;
}
function RuntimeAttachment(props) {
  const {
    initialDiscoveryRules = [],
    onChange = () => {}
  } = props;
  const [isEnabled, setIsEnabled] = (0, _react.useState)(Boolean(props.initialIsEnabled));
  const [discoveryRuleList, setDiscoveryRuleList] = (0, _react.useState)(initialDiscoveryRules.map(discoveryRule => ({
    id: generateId(),
    discoveryRule
  })));
  const [editDiscoveryRuleId, setEditDiscoveryRuleId] = (0, _react.useState)(null);
  const [version, setVersion] = (0, _react.useState)(props.version);
  const [isValidVersion, setIsValidVersion] = (0, _react.useState)(validateVersion(props.version));
  (0, _react.useEffect)(() => {
    // Invalidates the package policy, so save button is disabled
    // until a valid version is provided
    if (isEnabled && !isValidVersion) {
      props.invalidatePackagePolicy();
    }
  },
  // props shouldn't be listed as dependency here
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isEnabled, isValidVersion]);
  const onToggleEnable = (0, _react.useCallback)(() => {
    const nextIsEnabled = !isEnabled;
    setIsEnabled(nextIsEnabled);
    onChange({
      enabled: nextIsEnabled,
      discoveryRules: nextIsEnabled ? discoveryRuleList.map(({
        discoveryRule
      }) => discoveryRule) : [],
      version: nextIsEnabled ? version : null
    });
  }, [isEnabled, onChange, discoveryRuleList, version]);
  const onDelete = (0, _react.useCallback)(discoveryRuleId => {
    const filteredDiscoveryRuleList = discoveryRuleList.filter(({
      id
    }) => id !== discoveryRuleId);
    setDiscoveryRuleList(filteredDiscoveryRuleList);
    onChange({
      enabled: isEnabled,
      discoveryRules: filteredDiscoveryRuleList.map(({
        discoveryRule
      }) => discoveryRule),
      version
    });
  }, [isEnabled, discoveryRuleList, onChange, version]);
  const onEdit = (0, _react.useCallback)(discoveryRuleId => {
    const editingDiscoveryRule = discoveryRuleList.find(({
      id
    }) => id === discoveryRuleId);
    if (editingDiscoveryRule) {
      const {
        discoveryRule: {
          operation,
          type,
          probe
        }
      } = editingDiscoveryRule;
      setStagedOperationText(operation);
      setStagedTypeText(type);
      setStagedProbeText(probe);
      setEditDiscoveryRuleId(discoveryRuleId);
    }
  }, [discoveryRuleList]);
  const [stagedOperationText, setStagedOperationText] = (0, _react.useState)('');
  const [stagedTypeText, setStagedTypeText] = (0, _react.useState)('');
  const [stagedProbeText, setStagedProbeText] = (0, _react.useState)('');
  const onChangeOperation = (0, _react.useCallback)(operationText => {
    setStagedOperationText(operationText);
    const selectedOperationTypes = props.operationTypes.find(({
      operation
    }) => operationText === operation.value);
    const selectedTypeAvailable = selectedOperationTypes === null || selectedOperationTypes === void 0 ? void 0 : selectedOperationTypes.types.some(({
      value
    }) => stagedTypeText === value);
    if (!selectedTypeAvailable) {
      var _selectedOperationTyp;
      setStagedTypeText((_selectedOperationTyp = selectedOperationTypes === null || selectedOperationTypes === void 0 ? void 0 : selectedOperationTypes.types[0].value) !== null && _selectedOperationTyp !== void 0 ? _selectedOperationTyp : '');
    }
  }, [props.operationTypes, stagedTypeText]);
  const onChangeType = (0, _react.useCallback)(operationText => {
    setStagedTypeText(operationText);
    if (operationText === DISCOVERY_RULE_TYPE_ALL) {
      setStagedProbeText('');
    }
  }, []);
  const onChangeProbe = (0, _react.useCallback)(operationText => {
    setStagedProbeText(operationText);
  }, []);
  const onCancel = (0, _react.useCallback)(() => {
    if (editDiscoveryRuleId === STAGED_DISCOVERY_RULE_ID) {
      onDelete(STAGED_DISCOVERY_RULE_ID);
    }
    setEditDiscoveryRuleId(null);
  }, [editDiscoveryRuleId, onDelete]);
  const onSubmit = (0, _react.useCallback)(() => {
    const editDiscoveryRuleIndex = discoveryRuleList.findIndex(({
      id
    }) => id === editDiscoveryRuleId);
    const editDiscoveryRule = discoveryRuleList[editDiscoveryRuleIndex];
    const nextDiscoveryRuleList = [...discoveryRuleList.slice(0, editDiscoveryRuleIndex), {
      id: editDiscoveryRule.id === STAGED_DISCOVERY_RULE_ID ? generateId() : editDiscoveryRule.id,
      discoveryRule: {
        operation: stagedOperationText,
        type: stagedTypeText,
        probe: stagedProbeText
      }
    }, ...discoveryRuleList.slice(editDiscoveryRuleIndex + 1)];
    setDiscoveryRuleList(nextDiscoveryRuleList);
    setEditDiscoveryRuleId(null);
    onChange({
      enabled: isEnabled,
      discoveryRules: nextDiscoveryRuleList.map(({
        discoveryRule
      }) => discoveryRule),
      version
    });
  }, [isEnabled, editDiscoveryRuleId, stagedOperationText, stagedTypeText, stagedProbeText, discoveryRuleList, onChange, version]);
  const onAddRule = (0, _react.useCallback)(() => {
    const firstOperationType = props.operationTypes[0];
    const operationText = firstOperationType.operation.value;
    const typeText = firstOperationType.types[0].value;
    const valueText = '';
    setStagedOperationText(operationText);
    setStagedTypeText(typeText);
    setStagedProbeText(valueText);
    const nextDiscoveryRuleList = [{
      id: STAGED_DISCOVERY_RULE_ID,
      discoveryRule: {
        operation: operationText,
        type: typeText,
        probe: valueText
      }
    }, ...discoveryRuleList];
    setDiscoveryRuleList(nextDiscoveryRuleList);
    setEditDiscoveryRuleId(STAGED_DISCOVERY_RULE_ID);
  }, [discoveryRuleList, props.operationTypes]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      const nextDiscoveryRuleList = (0, _eui.euiDragDropReorder)(discoveryRuleList, source.index, destination.index);
      setDiscoveryRuleList(nextDiscoveryRuleList);
      onChange({
        enabled: isEnabled,
        discoveryRules: nextDiscoveryRuleList.map(({
          discoveryRule
        }) => discoveryRule),
        version
      });
    }
  }, [isEnabled, discoveryRuleList, onChange, version]);
  function onChangeVersion(nextVersion) {
    const isNextVersionValid = validateVersion(nextVersion);
    setIsValidVersion(isNextVersionValid);
    setVersion(nextVersion);
    if (!isNextVersionValid) {
      return;
    }
    onChange({
      enabled: isEnabled,
      discoveryRules: isEnabled ? discoveryRuleList.map(({
        discoveryRule
      }) => discoveryRule) : [],
      version: nextVersion
    });
  }
  return /*#__PURE__*/_react.default.createElement(_runtime_attachment.RuntimeAttachment, {
    isEnabled: isEnabled,
    onToggleEnable: onToggleEnable,
    discoveryRuleList: discoveryRuleList,
    setDiscoveryRuleList: setDiscoveryRuleList,
    onDelete: onDelete,
    editDiscoveryRuleId: editDiscoveryRuleId,
    onEdit: onEdit,
    onChangeOperation: onChangeOperation,
    stagedOperationText: stagedOperationText,
    onChangeType: onChangeType,
    stagedTypeText: stagedTypeText,
    onChangeProbe: onChangeProbe,
    stagedProbeText: stagedProbeText,
    onCancel: onCancel,
    onSubmit: onSubmit,
    onAddRule: onAddRule,
    operationTypes: props.operationTypes,
    toggleDescription: props.toggleDescription,
    discoveryRulesDescription: props.discoveryRulesDescription,
    showUnsavedWarning: props.showUnsavedWarning,
    onDragEnd: onDragEnd,
    version: version,
    onChangeVersion: onChangeVersion,
    isValidVersion: isValidVersion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 5
    }
  });
}
const generateId = (0, _eui.htmlIdGenerator)();