"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesTable = ServicesTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _download_json = require("../../../../utils/download_json");
var _environment_badge = require("../../../shared/environment_badge");
var _formatters = require("../../../../../common/utils/formatters");
var _service_link = require("../../../shared/links/apm/service_link");
var _truncate_with_tooltip = require("../../../shared/truncate_with_tooltip");
var _storage_details_per_service = require("./storage_details_per_service");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _i18n2 = require("../../../../../common/i18n");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_progressive_fetcher = require("../../../../hooks/use_progressive_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _size_label = require("./size_label");
var _join_by_key = require("../../../../../common/utils/join_by_key");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/services_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var StorageExplorerFieldName = /*#__PURE__*/function (StorageExplorerFieldName) {
  StorageExplorerFieldName["ServiceName"] = "serviceName";
  StorageExplorerFieldName["Environments"] = "environments";
  StorageExplorerFieldName["Sampling"] = "sampling";
  StorageExplorerFieldName["Size"] = "size";
  return StorageExplorerFieldName;
}(StorageExplorerFieldName || {});
const initialSortField = StorageExplorerFieldName.ServiceName;
const initialSortDirection = 'asc';
function ServicesTable({
  summaryStatsData,
  loadingSummaryStats
}) {
  var _serviceStatisticsFet, _serviceStatisticsFet2, _sortedAndFilteredSer;
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      indexLifecyclePhase,
      comparisonEnabled: urlComparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled
  });
  const toggleRowDetails = selectedServiceName => {
    const expandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (expandedRowMapValues[selectedServiceName]) {
      delete expandedRowMapValues[selectedServiceName];
    } else {
      expandedRowMapValues[selectedServiceName] = /*#__PURE__*/_react.default.createElement(_storage_details_per_service.StorageDetailsPerService, {
        serviceName: selectedServiceName,
        indexLifecyclePhase: indexLifecyclePhase,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(expandedRowMapValues);
  };
  const sortedAndFilteredServicesFetch = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_explorer/get_services', {
      params: {
        query: {
          environment,
          kuery,
          indexLifecyclePhase,
          start,
          end
        }
      }
    });
  }, [environment, kuery, indexLifecyclePhase, start, end]);
  const serviceStatisticsFetch = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_explorer', {
      params: {
        query: {
          indexLifecyclePhase,
          start,
          end,
          environment,
          kuery
        }
      }
    });
  }, [indexLifecyclePhase, start, end, environment, kuery]);
  const serviceStatisticsItems = (_serviceStatisticsFet = (_serviceStatisticsFet2 = serviceStatisticsFetch.data) === null || _serviceStatisticsFet2 === void 0 ? void 0 : _serviceStatisticsFet2.serviceStatistics) !== null && _serviceStatisticsFet !== void 0 ? _serviceStatisticsFet : [];
  const preloadedServices = ((_sortedAndFilteredSer = sortedAndFilteredServicesFetch.data) === null || _sortedAndFilteredSer === void 0 ? void 0 : _sortedAndFilteredSer.services) || [];
  const loading = serviceStatisticsFetch.status === _use_fetcher.FETCH_STATUS.LOADING;
  const items = (0, _join_by_key.joinByKey)([...preloadedServices, ...serviceStatisticsItems], StorageExplorerFieldName.ServiceName);
  const columns = [{
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.table.serviceColumnName', {
      defaultMessage: 'Service'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName
    }) => {
      const serviceLinkQuery = {
        comparisonEnabled,
        environment,
        kuery,
        rangeFrom,
        rangeTo,
        serviceGroup: ''
      };
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        "data-test-subj": "apmStorageExplorerServiceLink",
        text: serviceName || _i18n2.NOT_AVAILABLE_LABEL,
        content: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
          query: serviceLinkQuery,
          serviceName: serviceName,
          agentName: agentName,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 15
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'environment',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.table.environmentColumnName', {
      defaultMessage: 'Environment'
    }),
    render: (_, {
      environments
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments !== null && environments !== void 0 ? environments : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 40
      }
    }),
    sortable: true
  }, {
    field: 'sampling',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.storageExplorer.table.samplingColumnDescription', {
        defaultMessage: `The number of sampled transactions divided by total throughput. This value may differ from the configured transaction sample rate because it might be affected by the initial service's decision when using head-based sampling or by a set of policies when using tail-based sampling.`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.storageExplorer.table.samplingColumnName', {
      defaultMessage: 'Sampling rate'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }))),
    render: value => (0, _formatters.asPercent)(parseFloat(value), 1),
    sortable: true
  }, {
    field: 'size',
    name: /*#__PURE__*/_react.default.createElement(_size_label.SizeLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }),
    render: (_, {
      size
    }) => (0, _formatters.asDynamicBytes)(size) || _i18n2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.storageExplorer.table.expandRow', {
      defaultMessage: 'Expand row'
    }))),
    render: ({
      serviceName
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `storageDetailsButton_${serviceName}`,
        onClick: () => toggleRowDetails(serviceName),
        "aria-label": itemIdToExpandedRowMap[serviceName] ? _i18n.i18n.translate('xpack.apm.storageExplorer.table.collapse', {
          defaultMessage: 'Collapse'
        }) : _i18n.i18n.translate('xpack.apm.storageExplorer.table.expand', {
          defaultMessage: 'Expand'
        }),
        iconType: itemIdToExpandedRowMap[serviceName] ? 'arrowUp' : 'arrowDown',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 11
        }
      });
    }
  }];
  const isDownloadButtonDisable = (0, _lodash.isEmpty)(serviceStatisticsItems) || loadingSummaryStats;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    css: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 5
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "StorageExplorerDownloadReportButton",
    iconType: "download",
    isDisabled: isDownloadButtonDisable,
    onClick: () => {
      var _summaryStatsData$num;
      return (0, _download_json.downloadJson)({
        fileName: `storage-explorefpr-${(0, _moment.default)(Date.now()).format('YYYYMMDDHHmmss')}.json`,
        data: {
          filters: {
            rangeFrom,
            rangeTo,
            environment,
            kuery,
            indexLifecyclePhase
          },
          summary: {
            totalSize: (0, _formatters.asDynamicBytes)(summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.totalSize),
            diskSpaceUsedPct: (0, _formatters.asPercent)(summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.diskSpaceUsedPct, 1),
            estimatedIncrementalSize: (0, _formatters.asDynamicBytes)(summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.estimatedIncrementalSize),
            dailyDataGeneration: (0, _formatters.asDynamicBytes)(summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.dailyDataGeneration),
            tracesPerMinute: (0, _formatters.asTransactionRate)(summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.tracesPerMinute),
            numberOfServices: ((_summaryStatsData$num = summaryStatsData === null || summaryStatsData === void 0 ? void 0 : summaryStatsData.numberOfServices) !== null && _summaryStatsData$num !== void 0 ? _summaryStatsData$num : 0).toString()
          },
          services: serviceStatisticsItems.map(item => ({
            ...item,
            sampling: (0, _formatters.asPercent)(item === null || item === void 0 ? void 0 : item.sampling, 1),
            size: item !== null && item !== void 0 && item.size ? (0, _formatters.asDynamicBytes)(item === null || item === void 0 ? void 0 : item.size) : _i18n2.NOT_AVAILABLE_LABEL
          }))
        }
      });
    },
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.downloadReport', {
    defaultMessage: 'Download report'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.apm.storageExplorer.table.caption', {
      defaultMessage: 'Storage explorer'
    }),
    items: items !== null && items !== void 0 ? items : [],
    columns: columns,
    pagination: true,
    sorting: {
      sort: {
        field: initialSortField,
        direction: initialSortDirection
      }
    },
    itemId: "serviceName",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    "data-test-subj": "storageExplorerServicesTable",
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.storageExplorer.table.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    message: loading ? _i18n.i18n.translate('xpack.apm.storageExplorer.table.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.storageExplorer.table.noResults', {
      defaultMessage: 'No data found'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }));
}