"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsList = StatsList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _spark_plot = require("../../../shared/charts/spark_plot");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/popover/stats_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LoadingSpinner() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    style: {
      height: 170
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }));
}
function NoDataMessage() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.popover.noDataText', {
    defaultMessage: `No data for selected environment. Try switching to another environment.`
  }));
}
function StatsList({
  data,
  isLoading
}) {
  var _transactionStats$thr, _transactionStats$lat;
  const {
    currentPeriod = {},
    previousPeriod
  } = data;
  const {
    cpuUsage,
    failedTransactionsRate,
    memoryUsage,
    transactionStats
  } = currentPeriod;
  const hasData = [cpuUsage === null || cpuUsage === void 0 ? void 0 : cpuUsage.value, failedTransactionsRate === null || failedTransactionsRate === void 0 ? void 0 : failedTransactionsRate.value, memoryUsage === null || memoryUsage === void 0 ? void 0 : memoryUsage.value, transactionStats === null || transactionStats === void 0 ? void 0 : (_transactionStats$thr = transactionStats.throughput) === null || _transactionStats$thr === void 0 ? void 0 : _transactionStats$thr.value, transactionStats === null || transactionStats === void 0 ? void 0 : (_transactionStats$lat = transactionStats.latency) === null || _transactionStats$lat === void 0 ? void 0 : _transactionStats$lat.value].some(stat => (0, _lodash.isNumber)(stat));
  const items = (0, _react.useMemo)(() => {
    var _currentPeriod$transa, _currentPeriod$transa2, _currentPeriod$transa3, _currentPeriod$transa4, _previousPeriod$trans, _previousPeriod$trans2, _currentPeriod$transa5, _currentPeriod$transa6, _currentPeriod$transa7, _currentPeriod$transa8, _previousPeriod$trans3, _previousPeriod$trans4, _currentPeriod$failed, _currentPeriod$failed2, _previousPeriod$faile, _currentPeriod$cpuUsa, _currentPeriod$cpuUsa2, _previousPeriod$cpuUs, _currentPeriod$memory, _currentPeriod$memory2, _previousPeriod$memor;
    return [{
      title: _i18n.i18n.translate('xpack.apm.serviceMap.avgTransDurationPopoverStat', {
        defaultMessage: 'Latency (avg.)'
      }),
      valueLabel: (0, _formatters.asDuration)(currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$transa = currentPeriod.transactionStats) === null || _currentPeriod$transa === void 0 ? void 0 : (_currentPeriod$transa2 = _currentPeriod$transa.latency) === null || _currentPeriod$transa2 === void 0 ? void 0 : _currentPeriod$transa2.value),
      timeseries: currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$transa3 = currentPeriod.transactionStats) === null || _currentPeriod$transa3 === void 0 ? void 0 : (_currentPeriod$transa4 = _currentPeriod$transa3.latency) === null || _currentPeriod$transa4 === void 0 ? void 0 : _currentPeriod$transa4.timeseries,
      previousPeriodTimeseries: previousPeriod === null || previousPeriod === void 0 ? void 0 : (_previousPeriod$trans = previousPeriod.transactionStats) === null || _previousPeriod$trans === void 0 ? void 0 : (_previousPeriod$trans2 = _previousPeriod$trans.latency) === null || _previousPeriod$trans2 === void 0 ? void 0 : _previousPeriod$trans2.timeseries,
      color: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG).currentPeriodColor,
      comparisonSeriesColor: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG).previousPeriodColor
    }, {
      title: _i18n.i18n.translate('xpack.apm.serviceMap.avgReqPerMinutePopoverMetric', {
        defaultMessage: 'Throughput (avg.)'
      }),
      valueLabel: (0, _formatters.asTransactionRate)(currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$transa5 = currentPeriod.transactionStats) === null || _currentPeriod$transa5 === void 0 ? void 0 : (_currentPeriod$transa6 = _currentPeriod$transa5.throughput) === null || _currentPeriod$transa6 === void 0 ? void 0 : _currentPeriod$transa6.value),
      timeseries: currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$transa7 = currentPeriod.transactionStats) === null || _currentPeriod$transa7 === void 0 ? void 0 : (_currentPeriod$transa8 = _currentPeriod$transa7.throughput) === null || _currentPeriod$transa8 === void 0 ? void 0 : _currentPeriod$transa8.timeseries,
      previousPeriodTimeseries: previousPeriod === null || previousPeriod === void 0 ? void 0 : (_previousPeriod$trans3 = previousPeriod.transactionStats) === null || _previousPeriod$trans3 === void 0 ? void 0 : (_previousPeriod$trans4 = _previousPeriod$trans3.throughput) === null || _previousPeriod$trans4 === void 0 ? void 0 : _previousPeriod$trans4.timeseries,
      color: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT).currentPeriodColor,
      comparisonSeriesColor: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT).previousPeriodColor
    }, {
      title: _i18n.i18n.translate('xpack.apm.serviceMap.errorRatePopoverStat', {
        defaultMessage: 'Failed transaction rate (avg.)'
      }),
      valueLabel: (0, _formatters.asPercent)(currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$failed = currentPeriod.failedTransactionsRate) === null || _currentPeriod$failed === void 0 ? void 0 : _currentPeriod$failed.value, 1, ''),
      timeseries: currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$failed2 = currentPeriod.failedTransactionsRate) === null || _currentPeriod$failed2 === void 0 ? void 0 : _currentPeriod$failed2.timeseries,
      previousPeriodTimeseries: previousPeriod === null || previousPeriod === void 0 ? void 0 : (_previousPeriod$faile = previousPeriod.failedTransactionsRate) === null || _previousPeriod$faile === void 0 ? void 0 : _previousPeriod$faile.timeseries,
      color: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE).currentPeriodColor,
      comparisonSeriesColor: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE).previousPeriodColor
    }, {
      title: _i18n.i18n.translate('xpack.apm.serviceMap.avgCpuUsagePopoverStat', {
        defaultMessage: 'CPU usage (avg.)'
      }),
      valueLabel: (0, _formatters.asPercent)(currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$cpuUsa = currentPeriod.cpuUsage) === null || _currentPeriod$cpuUsa === void 0 ? void 0 : _currentPeriod$cpuUsa.value, 1, ''),
      timeseries: currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$cpuUsa2 = currentPeriod.cpuUsage) === null || _currentPeriod$cpuUsa2 === void 0 ? void 0 : _currentPeriod$cpuUsa2.timeseries,
      previousPeriodTimeseries: previousPeriod === null || previousPeriod === void 0 ? void 0 : (_previousPeriod$cpuUs = previousPeriod.cpuUsage) === null || _previousPeriod$cpuUs === void 0 ? void 0 : _previousPeriod$cpuUs.timeseries,
      color: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.CPU_USAGE).currentPeriodColor,
      comparisonSeriesColor: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.CPU_USAGE).previousPeriodColor
    }, {
      title: _i18n.i18n.translate('xpack.apm.serviceMap.avgMemoryUsagePopoverStat', {
        defaultMessage: 'Memory usage (avg.)'
      }),
      valueLabel: (0, _formatters.asPercent)(currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$memory = currentPeriod.memoryUsage) === null || _currentPeriod$memory === void 0 ? void 0 : _currentPeriod$memory.value, 1, ''),
      timeseries: currentPeriod === null || currentPeriod === void 0 ? void 0 : (_currentPeriod$memory2 = currentPeriod.memoryUsage) === null || _currentPeriod$memory2 === void 0 ? void 0 : _currentPeriod$memory2.timeseries,
      previousPeriodTimeseries: previousPeriod === null || previousPeriod === void 0 ? void 0 : (_previousPeriod$memor = previousPeriod.memoryUsage) === null || _previousPeriod$memor === void 0 ? void 0 : _previousPeriod$memor.timeseries,
      color: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.MEMORY_USAGE).currentPeriodColor,
      comparisonSeriesColor: (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.MEMORY_USAGE).previousPeriodColor
    }];
  }, [currentPeriod, previousPeriod]);
  if (isLoading && !hasData) {
    return /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 12
      }
    });
  }
  if (!hasData) {
    return /*#__PURE__*/_react.default.createElement(NoDataMessage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, items.map(({
    title,
    valueLabel,
    timeseries,
    color,
    previousPeriodTimeseries,
    comparisonSeriesColor
  }) => {
    if (!valueLabel) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        display: 'flex',
        justifyContent: 'end'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 19
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    }, timeseries ? /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
      isLoading: isLoading,
      series: timeseries,
      color: color,
      valueLabel: valueLabel,
      comparisonSeries: previousPeriodTimeseries,
      comparisonSeriesColor: comparisonSeriesColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 21
      }
    }, valueLabel))));
  }));
}