"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampleDetailTabContent = ErrorSampleDetailTabContent;
exports.ErrorSampleDetails = ErrorSampleDetails;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _common = require("@kbn/observability-shared-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eventStacktrace = require("@kbn/event-stacktrace");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _transaction_detail_link = require("../../../shared/links/apm/transaction_detail_link");
var _url_helpers = require("../../../shared/links/url_helpers");
var _error_metadata = require("../../../shared/metadata_table/error_metadata");
var _summary = require("../../../shared/summary");
var _http_info_summary_item = require("../../../shared/summary/http_info_summary_item");
var _user_agent_summary_item = require("../../../shared/summary/user_agent_summary_item");
var _error_tabs = require("./error_tabs");
var _error_ui_actions_context_menu = require("./error_ui_actions_context_menu");
var _sample_summary = require("./sample_summary");
var _error_sample_contextual_insight = require("./error_sample_contextual_insight");
var _get_comparison_enabled = require("../../../shared/time_comparison/get_comparison_enabled");
var _build_url = require("../../../../utils/build_url");
var _open_error_in_discover_button = require("../../../shared/links/discover_links/open_error_in_discover_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/error_group_details/error_sampler/error_sample_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TransactionLinkName = _styled.default.div`
  margin-left: ${({
  theme
}) => theme.euiTheme.size.s};
  display: inline-block;
  vertical-align: middle;
`;
function getCurrentTab(tabs = [], currentTabKey) {
  const selectedTab = tabs.find(({
    key
  }) => key === currentTabKey);
  return selectedTab !== null && selectedTab !== void 0 ? selectedTab : (0, _lodash.first)(tabs) || {};
}
function ErrorSampleDetails({
  onSampleClick,
  errorSampleIds,
  errorSamplesFetchStatus,
  errorData,
  errorFetchStatus,
  occurrencesCount
}) {
  var _error$error$page, _error$url, _transaction$transact, _transaction$transact2, _transaction$url, _errorOrTransactionHt, _errorOrTransactionHt2, _errorOrTransactionHt3, _errorOrTransactionHt4, _error$error$exceptio, _error$error$exceptio2, _externalContextMenuI;
  const [sampleActivePage, setSampleActivePage] = (0, _react.useState)(0);
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      detailTab,
      offset,
      comparisonEnabled
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    uiActions,
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/crashes/{groupId}');
  const {
    kuery
  } = query;
  const loadingErrorSamplesData = (0, _use_fetcher.isPending)(errorSamplesFetchStatus);
  const loadingErrorData = (0, _use_fetcher.isPending)(errorFetchStatus);
  const isLoading = loadingErrorSamplesData || loadingErrorData;
  const isSucceeded = (0, _use_fetcher.isSuccess)(errorSamplesFetchStatus) && (0, _use_fetcher.isSuccess)(errorFetchStatus);
  const defaultComparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled: comparisonEnabled
  });
  (0, _react.useEffect)(() => {
    setSampleActivePage(0);
  }, [errorSampleIds]);
  const goToSample = index => {
    const sample = errorSampleIds[index];
    setSampleActivePage(index);
    onSampleClick(sample);
  };
  const {
    error,
    transaction
  } = errorData;
  const externalContextMenuItems = (0, _useAsync.default)(() => {
    return (0, _public.getContextMenuItemsFromActions)({
      uiActions,
      triggerId: _common.ObservabilityTriggerId.ApmErrorContextMenu,
      context: {
        error,
        transaction
      }
    });
  }, [error, transaction, uiActions]);
  if (!error && (errorSampleIds === null || errorSampleIds === void 0 ? void 0 : errorSampleIds.length) === 0 && isSucceeded) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.apm.errorSampleDetails.sampleNotFound', {
        defaultMessage: 'The selected error cannot be found'
      })),
      titleSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    });
  }
  const tabs = (0, _error_tabs.getTabs)(error);
  const currentTab = getCurrentTab(tabs, detailTab);
  const urlFromError = ((_error$error$page = error.error.page) === null || _error$error$page === void 0 ? void 0 : _error$error$page.url) || ((_error$url = error.url) === null || _error$url === void 0 ? void 0 : _error$url.full);
  const urlFromTransaction = (transaction === null || transaction === void 0 ? void 0 : (_transaction$transact = transaction.transaction) === null || _transaction$transact === void 0 ? void 0 : (_transaction$transact2 = _transaction$transact.page) === null || _transaction$transact2 === void 0 ? void 0 : _transaction$transact2.url) || (transaction === null || transaction === void 0 ? void 0 : (_transaction$url = transaction.url) === null || _transaction$url === void 0 ? void 0 : _transaction$url.full);
  const errorOrTransactionUrl = error !== null && error !== void 0 && error.url ? error : transaction;
  const errorOrTransactionHttp = error !== null && error !== void 0 && error.http ? error : transaction;
  const errorOrTransactionUserAgent = error !== null && error !== void 0 && error.user_agent ? error.user_agent : transaction === null || transaction === void 0 ? void 0 : transaction.user_agent;

  // To get the error data needed for the summary we use the transaction fallback in case
  // the error data is not available.
  // In case of OTel the error data is not available in the error response and we need to use
  // the associated root span data (which is called "transaction" here because of the APM data model).
  const errorUrl = urlFromError || urlFromTransaction || (0, _build_url.buildUrl)(errorOrTransactionUrl);
  const method = errorOrTransactionHttp === null || errorOrTransactionHttp === void 0 ? void 0 : (_errorOrTransactionHt = errorOrTransactionHttp.http) === null || _errorOrTransactionHt === void 0 ? void 0 : (_errorOrTransactionHt2 = _errorOrTransactionHt.request) === null || _errorOrTransactionHt2 === void 0 ? void 0 : _errorOrTransactionHt2.method;
  const status = errorOrTransactionHttp === null || errorOrTransactionHttp === void 0 ? void 0 : (_errorOrTransactionHt3 = errorOrTransactionHttp.http) === null || _errorOrTransactionHt3 === void 0 ? void 0 : (_errorOrTransactionHt4 = _errorOrTransactionHt3.response) === null || _errorOrTransactionHt4 === void 0 ? void 0 : _errorOrTransactionHt4.status_code;
  const userAgent = errorOrTransactionUserAgent;
  const environment = error.service.environment;
  const serviceVersion = error.service.version;
  const isUnhandled = ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : (_error$error$exceptio2 = _error$error$exceptio[0]) === null || _error$error$exceptio2 === void 0 ? void 0 : _error$error$exceptio2.handled) === false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.errorSampleDetails.errorOccurrenceTitle', {
    defaultMessage: 'Error sample'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, !!(errorSampleIds !== null && errorSampleIds !== void 0 && errorSampleIds.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: errorSampleIds.length,
    activePage: sampleActivePage,
    onPageClick: goToSample,
    "aria-label": _i18n.i18n.translate('xpack.apm.errorSampleDetails.paginationAriaLabel', {
      defaultMessage: 'Error sample pages'
    }),
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  })), (_externalContextMenuI = externalContextMenuItems.value) !== null && _externalContextMenuI !== void 0 && _externalContextMenuI.length ? /*#__PURE__*/_react.default.createElement(_error_ui_actions_context_menu.ErrorUiActionsContextMenu, {
    items: externalContextMenuItems.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_open_error_in_discover_button.OpenErrorInDiscoverButton, {
    dataTestSubj: "errorGroupDetailsOpenErrorInDiscoverButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    "data-test-sub": "loading-content",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    items: [/*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
      timestamp: errorData ? error.timestamp.us / 1000 : 0,
      renderMode: "tooltip",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }), errorUrl ? /*#__PURE__*/_react.default.createElement(_http_info_summary_item.HttpInfoSummaryItem, {
      url: errorUrl,
      method: method,
      status: status,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 15
      }
    }) : null, userAgent !== null && userAgent !== void 0 && userAgent.name ? /*#__PURE__*/_react.default.createElement(_user_agent_summary_item.UserAgentSummaryItem, (0, _extends2.default)({}, userAgent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 31
      }
    })) : null, transaction && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.errorSampleDetails.relatedTransactionSample', {
        defaultMessage: 'Related transaction sample'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
      transactionName: transaction.transaction.name,
      href: router.link('/services/{serviceName}/transactions/view', {
        path: {
          serviceName: transaction.service.name
        },
        query: {
          ...query,
          traceId: transaction.trace.id,
          transactionId: transaction.transaction.id,
          transactionName: transaction.transaction.name,
          transactionType: transaction.transaction.type,
          comparisonEnabled: defaultComparisonEnabled,
          showCriticalPath: false,
          offset,
          kuery
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "merge",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(TransactionLinkName, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 19
      }
    }, transaction.transaction.name))), environment ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.errorSampleDetails.serviceEnvironment', {
        defaultMessage: 'Environment'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 17
      }
    }, environment)) : null, serviceVersion ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.errorSampleDetails.serviceVersion', {
        defaultMessage: 'Service version'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 17
      }
    }, serviceVersion)) : null, isUnhandled ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.apm.errorGroupDetails.unhandledLabel', {
      defaultMessage: 'Unhandled'
    })) : null],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    "data-test-sub": "loading-content",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_sample_summary.SampleSummary, {
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_error_sample_contextual_insight.ErrorSampleContextualInsight, {
    error: error,
    transaction: transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }, tabs.map(({
    key,
    label
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        history.replace({
          ...history.location,
          search: (0, _url_helpers.fromQuery)({
            ...(0, _url_helpers.toQuery)(history.location.search),
            detailTab: key
          })
        });
      },
      isSelected: currentTab.key === key,
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 13
      }
    }, label);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }), isLoading || !error ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    "data-test-sub": "loading-content",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(ErrorSampleDetailTabContent, {
    error: error,
    currentTab: currentTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }));
}
function ErrorSampleDetailTabContent({
  error,
  currentTab
}) {
  var _error$service$langua, _error$error$log, _exceptions$;
  const codeLanguage = error === null || error === void 0 ? void 0 : (_error$service$langua = error.service.language) === null || _error$service$langua === void 0 ? void 0 : _error$service$langua.name;
  const exceptions = (error === null || error === void 0 ? void 0 : error.error.exception) || [];
  const logStackframes = error === null || error === void 0 ? void 0 : (_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.stacktrace;
  const isPlaintextException = !!error.error.stack_trace && exceptions.length === 1 && !exceptions[0].stacktrace;
  switch (currentTab.key) {
    case _error_tabs.ErrorTabKey.LogStackTrace:
      return /*#__PURE__*/_react.default.createElement(_eventStacktrace.Stacktrace, {
        stackframes: logStackframes,
        codeLanguage: codeLanguage,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 14
        }
      });
    case _error_tabs.ErrorTabKey.ExceptionStacktrace:
      return isPlaintextException ? /*#__PURE__*/_react.default.createElement(_eventStacktrace.PlaintextStacktrace, {
        message: exceptions[0].message,
        type: (_exceptions$ = exceptions[0]) === null || _exceptions$ === void 0 ? void 0 : _exceptions$.type,
        stacktrace: error === null || error === void 0 ? void 0 : error.error.stack_trace,
        codeLanguage: codeLanguage,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 9
        }
      }) : /*#__PURE__*/_react.default.createElement(_eventStacktrace.ExceptionStacktrace, {
        codeLanguage: codeLanguage,
        exceptions: exceptions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 9
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_error_metadata.ErrorMetadata, {
        error: error,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 14
        }
      });
  }
}