"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsImportExport = DiagnosticsImportExport;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_diagnostics = require("./context/use_diagnostics");
var _index_templates_status = require("./summary_tab/index_templates_status");
var _indicies_status = require("./summary_tab/indicies_status");
var _data_streams_status = require("./summary_tab/data_streams_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/import_export_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DiagnosticsImportExport() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ExportCard, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ImportCard, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })));
}
function ExportCard() {
  const {
    diagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    isDisabled: isImported,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "importAction",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }),
    title: "Export",
    description: "Export the diagnostics report in order to provide it to Elastic Support",
    footer: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isImported,
      "data-test-subj": "apmDiagnosticsImportExportGoForItButton",
      "aria-label": "Export diagnostics report",
      onClick: () => {
        if (!diagnosticsBundle) {
          return;
        }
        const blob = new Blob([JSON.stringify(diagnosticsBundle, null, 2)], {
          type: 'text/plain'
        });
        const fileURL = URL.createObjectURL(blob);
        const {
          kibanaVersion
        } = diagnosticsBundle;
        const link = document.createElement('a');
        link.href = fileURL;
        link.download = `apm-diagnostics-${kibanaVersion}-${Date.now()}.json`;
        link.click();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, "Export")),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
}
function ImportCard() {
  const {
    setImportedDiagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const [importStatus, setImportStatus] = (0, _react.useState)({
    isValid: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "exportAction",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }),
    title: "Import diagnostics report",
    description: isImported ? 'Diagnostics report was imported' : `Import a diagnostics report in order to view the results in the UI`,
    footer: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, isImported ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmImportCardRemoveReportButton",
      onClick: () => setImportedDiagnosticsBundle(undefined),
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, "Remove report") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !importStatus.isValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 19
      }
    }, "The uploaded file could not be parsed: ", importStatus.errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      fullWidth: true,
      id: "file-picker",
      multiple: true,
      onChange: _files => {
        setImportStatus({
          isValid: true
        });
        if (_files && _files.length > 0) {
          const file = Array.from(_files)[0];
          const reader = new FileReader();
          reader.onload = evt => {
            try {
              var _evt$target;
              const diagnosticsBundle = JSON.parse(// @ts-expect-error
              evt === null || evt === void 0 ? void 0 : (_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : _evt$target.result);
              validateBundle(diagnosticsBundle);
              setImportedDiagnosticsBundle(diagnosticsBundle);
            } catch (e) {
              setImportStatus({
                isValid: false,
                errorMessage: e.message
              });
              console.error(`Could not parse file ${file.name}. ${e.message}`);
            }
          };
          reader.readAsText(file);
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
}
function validateBundle(diagnosticsBundle) {
  try {
    (0, _index_templates_status.getIsIndexTemplateOk)(diagnosticsBundle);
    (0, _indicies_status.getIsIndicesTabOk)(diagnosticsBundle);
    (0, _data_streams_status.getIsDataStreamTabOk)(diagnosticsBundle);
  } catch (e) {
    console.error('Error parsing uploaded bundle', e);
    throw e;
  }
}