"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsContext = void 0;
exports.DiagnosticsContextProvider = DiagnosticsContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/context/diagnostics_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiagnosticsContext = exports.DiagnosticsContext = /*#__PURE__*/_react.default.createContext({
  diagnosticsBundle: undefined,
  setImportedDiagnosticsBundle: () => undefined,
  status: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  refetch: () => undefined
});
function DiagnosticsContextProvider({
  children
}) {
  const {
    query: {
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/diagnostics/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo,
    optional: true
  });
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi(`GET /internal/apm/diagnostics`, {
      isCachable: false,
      params: {
        query: {
          start,
          end,
          kuery
        }
      }
    });
  }, [start, end, kuery]);
  const [importedDiagnosticsBundle, setImportedDiagnosticsBundle] = (0, _react.useState)(undefined);
  const value = (0, _react.useMemo)(() => {
    if (importedDiagnosticsBundle) {
      return {
        refetch,
        diagnosticsBundle: importedDiagnosticsBundle,
        setImportedDiagnosticsBundle,
        status: _use_fetcher.FETCH_STATUS.SUCCESS,
        isImported: true
      };
    }
    return {
      refetch,
      diagnosticsBundle: data,
      setImportedDiagnosticsBundle,
      status,
      isImported: false
    };
  }, [importedDiagnosticsBundle, setImportedDiagnosticsBundle, status, data, refetch]);
  return /*#__PURE__*/_react.default.createElement(DiagnosticsContext.Provider, {
    value: value,
    children: children,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 10
    }
  });
}